/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import com.dtyunxi.huieryun.core.model.Application;
import com.dtyunxi.huieryun.core.model.context.RequestContextHolder;
import com.dtyunxi.huieryun.core.support.policy.TokenCheckPolicy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;

public class RequestContextInterceptor
implements HandlerInterceptor {
    @Autowired(required=false)
    private TokenCheckPolicy tokenChecker;
    @Autowired
    private Application application;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.tokenChecker != null && !this.tokenChecker.accept(request)) {
            return false;
        }
        RequestContextHolder.build(request, this.application);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        RequestContextHolder.clean();
    }
}

