/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.core.support.LocalDateTimeMeta;
import com.dtyunxi.huieryun.core.util.UnixTimeConverter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class StringToDateConverter
implements Converter<String, Date> {
    private static final Logger log = LoggerFactory.getLogger(StringToDateConverter.class);

    public Date convert(String value) {
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        Date date = UnixTimeConverter.getDateFromUnixTime(value);
        if (date != null) {
            return date;
        }
        LocalDateTimeMeta meta = LocalDateTimeMeta.getMeta(value);
        if (meta == null) {
            log.warn("\u65e0\u6cd5\u8bc6\u522b\u7684\u683c\u5f0f\uff0c\u503c\uff1a{}", (Object)value);
            LocalDateTime localDateTime = LocalDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            if (null != localDateTime) {
                return Date.from(localDateTime.toInstant(ZoneOffset.ofHours(8)));
            }
            return null;
        }
        if (meta.getType() == 1) {
            LocalDateTime localDateTime = LocalDateTime.parse(value, meta.getFormatter());
            return Date.from(localDateTime.toInstant(ZoneOffset.ofHours(8)));
        }
        LocalDate localDate = LocalDate.parse(value, meta.getFormatter());
        return Date.from(localDate.atStartOfDay().toInstant(ZoneOffset.ofHours(8)));
    }
}

