/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support.policy.impl;

import com.dtyunxi.huieryun.core.support.policy.TokenCheckPolicy;
import com.dtyunxi.huieryun.core.util.JwtUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class DefaultTokenChecker
implements TokenCheckPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTokenChecker.class);
    @Value(value="${gtmc.glaf.security.policy.signature.key}")
    private String signKey;

    @Override
    public boolean accept(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        boolean exist = this.checkExist(token);
        if (exist) {
            return this.checkSign(token.trim());
        }
        return false;
    }

    private boolean checkExist(String token) {
        return StringUtils.isEmpty((Object)this.signKey) || !StringUtils.isEmpty((Object)token);
    }

    protected boolean checkSign(String token) {
        if (!StringUtils.isEmpty((Object)this.signKey)) {
            try {
                JwtUtil.parse(token, this.signKey);
            }
            catch (Exception e) {
                logger.warn("Token check failed with error: {}", (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }
}

