/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class IpUtil {
    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        ip = ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip) ? request.getRemoteAddr() : ip.split(",")[0];
        return ip;
    }

    public static String getLocalIp4() {
        InetAddress ia = IpUtil.getIp(true, false);
        if (ia != null) {
            return ia.getHostAddress();
        }
        return "unknown";
    }

    public static String getLocalIp6() {
        InetAddress ia = IpUtil.getIp(false, true);
        if (ia != null) {
            return ia.getHostAddress();
        }
        return "unknown";
    }

    private static InetAddress getIp(boolean ipv4, boolean ipv6) {
        Enumeration<NetworkInterface> outer = null;
        try {
            outer = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (outer.hasMoreElements()) {
            NetworkInterface ni = outer.nextElement();
            Enumeration<InetAddress> inner = ni.getInetAddresses();
            while (inner.hasMoreElements()) {
                InetAddress ia = inner.nextElement();
                if (ia.isLoopbackAddress() || !(ia instanceof Inet4Address ? ipv4 : ia instanceof Inet6Address && ipv6)) continue;
                return ia;
            }
        }
        return null;
    }
}

