/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JwtUtil {
    public static String create(String id, String subject, String signKey, int ttlInSeconds, Map<String, Object> claims) {
        return JwtUtil.create(id, subject, signKey, SignatureAlgorithm.HS256, ttlInSeconds, claims);
    }

    public static String create(String id, String subject, String signKey, SignatureAlgorithm sa, int ttlInSeconds, Map<String, Object> claims) {
        if (id == null || subject == null || signKey == null) {
            return null;
        }
        long nowInMs = System.currentTimeMillis();
        JwtBuilder jwtBuilder = Jwts.builder().setHeaderParam("typ", (Object)"JWT").setHeaderParam("alg", (Object)sa.getValue()).setClaims(claims).setId(id).setSubject(subject).setIssuer("GTMC").setIssuedAt(new Date(nowInMs)).signWith(sa, (Key)JwtUtil.generateKey(signKey));
        if (ttlInSeconds > 0) {
            jwtBuilder.setExpiration(new Date(nowInMs + (long)(ttlInSeconds * 1000)));
        }
        return jwtBuilder.compact();
    }

    public static Map<String, Object> parse(String jwt, String signKey) {
        return (Map)Jwts.parser().setSigningKey((Key)JwtUtil.generateKey(signKey)).parseClaimsJws(jwt).getBody();
    }

    private static SecretKey generateKey(String signKey) {
        byte[] byteKey = signKey.getBytes();
        return new SecretKeySpec(byteKey, 0, byteKey.length, "AES");
    }
}

