/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class SerializeUtil {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final ThreadLocal<Kryo> kryoLocal = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo kryo = new Kryo();
            kryo.setReferences(true);
            kryo.setRegistrationRequired(false);
            ((Kryo.DefaultInstantiatorStrategy)kryo.getInstantiatorStrategy()).setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            return kryo;
        }
    };

    public static Kryo getInstance() {
        return kryoLocal.get();
    }

    public static <T> byte[] writeToByteArray(T obj) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)byteArrayOutputStream);
        Kryo kryo = SerializeUtil.getInstance();
        kryo.writeClassAndObject(output, obj);
        output.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> String writeToString(T obj) {
        try {
            return new String(Base64.encodeBase64((byte[])SerializeUtil.writeToByteArray(obj)), DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T readFromByteArray(byte[] byteArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        Input input = new Input((InputStream)byteArrayInputStream);
        Kryo kryo = SerializeUtil.getInstance();
        return (T)kryo.readClassAndObject(input);
    }

    public static <T> T readFromString(String str) {
        try {
            return SerializeUtil.readFromByteArray(Base64.decodeBase64((byte[])str.getBytes(DEFAULT_ENCODING)));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> byte[] writeObjectToByteArray(T obj) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)byteArrayOutputStream);
        Kryo kryo = SerializeUtil.getInstance();
        kryo.writeObject(output, obj);
        output.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> String writeObjectToString(T obj) {
        try {
            return new String(Base64.encodeBase64((byte[])SerializeUtil.writeObjectToByteArray(obj)), DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T readObjectFromByteArray(byte[] byteArray, Class<T> clazz) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        Input input = new Input((InputStream)byteArrayInputStream);
        Kryo kryo = SerializeUtil.getInstance();
        return (T)kryo.readObject(input, clazz);
    }

    public static <T> T readObjectFromString(String str, Class<T> clazz) {
        try {
            return SerializeUtil.readObjectFromByteArray(Base64.decodeBase64((byte[])str.getBytes(DEFAULT_ENCODING)), clazz);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

