/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util;

import com.dtyunxi.huieryun.core.util.Time;
import java.math.BigDecimal;
import java.util.TimeZone;
import java.util.UUID;
import org.springframework.util.StringUtils;

public class Validator {
    public static final String TEL_REGEX = "[1]\\d{10}";

    public static boolean isEmpty(Object object) {
        return StringUtils.isEmpty((Object)object);
    }

    public static boolean isUUID(String string) {
        if (Validator.isEmpty(string)) {
            return false;
        }
        if (string.length() != 36) {
            return false;
        }
        try {
            UUID.fromString(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNotUUID(String string) {
        return !Validator.isUUID(string);
    }

    public static boolean isOutLimit(String string, int maxLen) {
        return !Validator.isEmpty(string) && string.length() > maxLen;
    }

    public static boolean isNumber(String source) {
        try {
            new BigDecimal(source).toString();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isMobilePhone(String phone) {
        return !Validator.isEmpty(phone) && phone.matches(TEL_REGEX);
    }

    public static boolean isShort(String value) {
        try {
            Short.parseShort(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLong(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDate(String value) {
        try {
            Time.parseLocalDateTime(value, TimeZone.getDefault().getID());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isUrlString(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            return false;
        }
        return value.matches("[a-z0-9_]*");
    }

    public static boolean isNotUrlString(String value) {
        return !Validator.isUrlString(value);
    }
}

