/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.support;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.core.support.LocalDateTimeMeta;
import com.dtyunxi.huieryun.core.util.UnixTimeConverter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class CustomLocalDateDeserializer
extends JsonDeserializer<LocalDate> {
    public static final CustomLocalDateDeserializer instance = new CustomLocalDateDeserializer();

    public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String value = jsonParser.getText();
        if (StrUtil.isBlank((CharSequence)value)) {
            return null;
        }
        LocalDate localdDate = UnixTimeConverter.getLocalDateFromUnixTime(value);
        if (localdDate != null) {
            return localdDate;
        }
        LocalDateTimeMeta meta = LocalDateTimeMeta.getMeta(value);
        if (meta != null) {
            return new LocalDateDeserializer(meta.getFormatter()).deserialize(jsonParser, deserializationContext);
        }
        return new LocalDateDeserializer(DateTimeFormatter.ISO_LOCAL_DATE).deserialize(jsonParser, deserializationContext);
    }
}

