/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.core.util;

import com.dtyunxi.huieryun.core.support.CustomDateDeserializer;
import com.dtyunxi.huieryun.core.support.CustomLocalDateDeserializer;
import com.dtyunxi.huieryun.core.support.CustomLocalDateTimeDeserializer;
import com.dtyunxi.huieryun.core.support.CustomLocalTimeDeserializer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class JSON {
    private static final ObjectMapper OBJECT_MAPPER;
    private static final ObjectMapper INDENT_OBJECT_MAPPER;

    public static <T> T parseObject(String json, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseList(String json, Class<T> valueType) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{valueType});
            return (List)OBJECT_MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String json, Type type) {
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructType(type);
            return (T)OBJECT_MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseList(String json, Type type) {
        try {
            JavaType valueType = OBJECT_MAPPER.getTypeFactory().constructType(type);
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new JavaType[]{valueType});
            return (List)OBJECT_MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String json, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseList(String json, TypeReference<T> typeReference) {
        try {
            JavaType valueType = OBJECT_MAPPER.getTypeFactory().constructType(typeReference.getType());
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new JavaType[]{valueType});
            return (List)OBJECT_MAPPER.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toIndentJsonString(Object object) {
        try {
            return INDENT_OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T clone(T source, Class<T> tClass) {
        return JSON.parseObject(JSON.toJsonString(source), tClass);
    }

    static {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)CustomLocalDateTimeDeserializer.instance);
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)CustomLocalDateDeserializer.instance);
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)CustomLocalTimeDeserializer.instance);
        javaTimeModule.addDeserializer(Date.class, (JsonDeserializer)CustomDateDeserializer.instance);
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        OBJECT_MAPPER.setTimeZone(TimeZone.getDefault());
        OBJECT_MAPPER.registerModule((Module)new ParameterNamesModule());
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        OBJECT_MAPPER.registerModule((Module)javaTimeModule);
        INDENT_OBJECT_MAPPER = new ObjectMapper();
        INDENT_OBJECT_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
        INDENT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        INDENT_OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        INDENT_OBJECT_MAPPER.setTimeZone(TimeZone.getDefault());
        INDENT_OBJECT_MAPPER.registerModule((Module)new ParameterNamesModule());
        INDENT_OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        INDENT_OBJECT_MAPPER.registerModule((Module)javaTimeModule);
    }
}

