/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.metadata.CustomColumnInfo;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.annotation.ShardingColumn;
import com.dtyunxi.eo.BaseEo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Column;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CustomTableInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CustomTableInfo.class);
    private static final long serialVersionUID = 7988187026023138738L;
    private final TableInfo tableInfo;
    private List<CustomColumnInfo> columns;
    private static List<CustomColumnInfo> baseColumns;
    private List<ShardingColumn> shardingColumns;
    private String shardingColumnName;
    private String logicColumnName;
    private String version;
    private static final String SQL_SELECT_TMP = "%s AS %s";

    public CustomTableInfo(TableInfo tableInfo, boolean ignoreWithoutColumnAnnotationField) {
        this.tableInfo = tableInfo;
        List tableFieldInfos = tableInfo.getFieldList();
        if (CollectionUtil.isEmpty(baseColumns)) {
            List declaredFields = Stream.of(BaseEo.class.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class) || field.isAnnotationPresent(Id.class)).collect(Collectors.toList());
            baseColumns = new ArrayList<CustomColumnInfo>(declaredFields.size());
            tableFieldInfos.forEach(tableFieldInfo -> {
                if (declaredFields.contains(tableFieldInfo.getField())) {
                    CustomColumnInfo baseColumn = new CustomColumnInfo((TableFieldInfo)tableFieldInfo);
                    baseColumns.add(baseColumn);
                }
            });
            if (CollectionUtil.isNotEmpty(baseColumns)) {
                String internedName = "id".intern();
                for (Field idField : declaredFields) {
                    if (idField.getName() != internedName) continue;
                    baseColumns.add(new CustomColumnInfo("id", "id", idField));
                    break;
                }
            }
        }
        int initialCapacity = tableFieldInfos.size();
        this.columns = new ArrayList<CustomColumnInfo>(initialCapacity);
        ShardingColumn[] shardingColumnAnnotations = (ShardingColumn[])tableInfo.getEntityType().getAnnotationsByType(ShardingColumn.class);
        this.shardingColumns = Arrays.asList(shardingColumnAnnotations);
        List shardingColumnNames = this.shardingColumns.parallelStream().map(ShardingColumn::name).collect(Collectors.toList());
        ArrayList exclusionFieldList = ignoreWithoutColumnAnnotationField ? new ArrayList() : new ArrayList(0);
        AtomicBoolean needReInitResultMapIfNeed = new AtomicBoolean(false);
        tableFieldInfos.forEach(tableFieldInfo -> {
            Object column;
            String columnName;
            Field tableFieldInfoField = tableFieldInfo.getField();
            if (ignoreWithoutColumnAnnotationField && !tableFieldInfoField.isAnnotationPresent(Column.class) && !tableFieldInfoField.isAnnotationPresent(Version.class)) {
                exclusionFieldList.add(tableFieldInfo);
                return;
            }
            if (tableFieldInfoField.isAnnotationPresent(Column.class) && StringUtils.hasText((String)(columnName = (column = tableFieldInfoField.getAnnotation(Column.class)).name())) && !columnName.equalsIgnoreCase(tableFieldInfo.getColumn())) {
                log.warn("\u5b9e\u9645\u5217\u540d\u548c\u5b57\u6bb5\u540d\u4e0d\u4e00\u81f4,\u7c7b\u540d\uff1a{}\u5b57\u6bb5\u540d\uff1a{},\u8868\u540d\uff1a{},\u5217\u540d\uff1a{}", new Object[]{tableInfo.getEntityType().getName(), tableFieldInfo.getColumn(), tableInfo.getTableName(), columnName});
                try {
                    Field field = ReflectUtil.getField(TableFieldInfo.class, (String)"column");
                    field.setAccessible(true);
                    field.set(tableFieldInfo, columnName);
                    field = ReflectUtil.getField(TableFieldInfo.class, (String)"sqlSelect");
                    field.setAccessible(true);
                    field.set(tableFieldInfo, String.format(SQL_SELECT_TMP, columnName, tableFieldInfo.getProperty()));
                }
                catch (IllegalAccessException | SecurityException e) {
                    log.warn("\u5f3a\u5236\u8bbe\u7f6e\u5217\u540d\u5931\u8d25\uff01", (Throwable)e);
                }
                log.warn("\u8bbe\u7f6e\u540e\u5b9e\u9645\u5217\u540d\u548c\u5b57\u6bb5\u540d\u4e00\u81f4\u4e86,\u7c7b\u540d\uff1a{}\u5b57\u6bb5\u540d\uff1a{},\u8868\u540d\uff1a{},\u5217\u540d\uff1a{}", new Object[]{tableInfo.getEntityType().getName(), tableFieldInfo.getColumn(), tableInfo.getTableName(), columnName});
            }
            column = new CustomColumnInfo((TableFieldInfo)tableFieldInfo);
            this.columns.add((CustomColumnInfo)column);
            if (shardingColumnNames != null && shardingColumnNames.contains(((CustomColumnInfo)column).getColumn()) || shardingColumnNames.contains(((CustomColumnInfo)column).getProperty())) {
                ((CustomColumnInfo)column).setShardColumn(true);
                if (this.shardingColumnName == null) {
                    this.shardingColumnName = tableFieldInfo.getProperty();
                }
            }
            if (tableFieldInfoField.isAnnotationPresent(LogicColumn.class)) {
                this.logicColumnName = tableFieldInfoField.getName();
            }
        });
        if (ObjectUtil.isNotEmpty(exclusionFieldList)) {
            ArrayList fieldList = new ArrayList(initialCapacity);
            fieldList.addAll(tableFieldInfos);
            fieldList.removeAll(exclusionFieldList);
            tableInfo.setFieldList(fieldList);
        }
    }

    public CustomColumnInfo getColumnInfo(String property) {
        if (this.columns == null && baseColumns == null) {
            return null;
        }
        if (this.columns != null) {
            for (CustomColumnInfo column : this.columns) {
                if (!column.getColumn().equals(property) && !column.getProperty().equals(property)) continue;
                return column;
            }
        }
        if (baseColumns != null) {
            for (CustomColumnInfo column : baseColumns) {
                if (!column.getColumn().equals(property) && !column.getProperty().equals(property)) continue;
                return column;
            }
        }
        return null;
    }

    public void addShardingColumns(ShardingColumn[] shardingColumns) {
        if (shardingColumns == null || shardingColumns.length == 0) {
            return;
        }
        this.shardingColumns = Arrays.asList(shardingColumns);
    }

    public String getIdColumn() {
        return this.tableInfo.getKeyColumn();
    }

    public String getIdProperty() {
        return this.tableInfo.getKeyProperty();
    }

    public Class<?> getKeyType() {
        return this.tableInfo.getKeyType();
    }

    public String getTableName() {
        return this.tableInfo.getTableName();
    }

    public Class<?> getEntityType() {
        return this.tableInfo.getEntityType();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<CustomColumnInfo> getColumns() {
        return this.columns;
    }

    public static List<CustomColumnInfo> getBaseColumns() {
        return baseColumns;
    }

    public List<ShardingColumn> getShardingColumns() {
        return this.shardingColumns;
    }

    public String getShardingColumnName() {
        return this.shardingColumnName;
    }

    public void setShardingColumnName(String shardingColumnName) {
        this.shardingColumnName = shardingColumnName;
    }

    public String getLogicColumnName() {
        return this.logicColumnName;
    }

    public void setLogicColumnName(String logicColumnName) {
        this.logicColumnName = logicColumnName;
    }
}

