/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.dao.mybatis.das.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.dtyunxi.huieryun.core.model.page.Conditions;
import com.dtyunxi.huieryun.core.model.page.Filter;
import com.dtyunxi.huieryun.core.model.page.Page;
import com.dtyunxi.huieryun.core.model.page.Pageable;
import com.dtyunxi.huieryun.dao.entity.Entity;
import com.dtyunxi.huieryun.dao.mybatis.das.BaseMpDas;
import com.dtyunxi.huieryun.dao.mybatis.mapper.BaseMpMapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ResolvableType;
import org.springframework.transaction.annotation.Transactional;

public class BaseMpDasImpl<T extends Entity<ID, T>, ID extends Serializable & Comparable<ID>>
implements BaseMpDas<T, ID> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BaseMpMapper<T, ID> baseMapper;
    protected Class<T> entityClass;

    public BaseMpDasImpl() {
        ResolvableType resolvableType = ResolvableType.forClass(this.getClass());
        this.entityClass = resolvableType.getSuperType().getGeneric(new int[0]).resolve();
    }

    protected static boolean retBool(Integer result) {
        return SqlHelper.retBool((Integer)result);
    }

    protected Class<T> currentModelClass() {
        return this.entityClass;
    }

    protected SqlSession sqlSessionBatch() {
        return SqlHelper.sqlSessionBatch(this.currentModelClass());
    }

    protected String sqlStatement(SqlMethod sqlMethod) {
        return SqlHelper.table(this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }

    public ID create(T entity) {
        this.baseMapper.insert(entity);
        return (ID)entity.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean create(Collection<T> entityList) {
        return this.create(entityList, 30);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean create(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int i = 0;
            String sqlStatement = this.sqlStatement(SqlMethod.INSERT_ONE);
            for (Entity anEntityList : entityList) {
                batchSqlSession.insert(sqlStatement, (Object)anEntityList);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw ExceptionUtils.mpe((String)"Error: Cannot execute saveBatch Method. Cause", (Throwable)e, (Object[])new Object[0]);
        }
        return true;
    }

    public ID save(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo && StrUtil.isNotEmpty((CharSequence)tableInfo.getKeyProperty())) {
                Object idVal = ReflectionKit.getFieldValue(entity, (String)tableInfo.getKeyProperty());
                if (StringUtils.checkValNull((Object)idVal)) {
                    this.create(entity);
                } else if (!this.update(entity)) {
                    this.create(entity);
                }
            } else {
                throw ExceptionUtils.mpe((String)"Error:  Can not execute. Could not find @TableId.", (Object[])new Object[0]);
            }
        }
        return (ID)entity.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean save(Collection<T> entityList) {
        return this.save(entityList, 30);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean save(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            for (Entity anEntityList : entityList) {
                this.save((T)anEntityList);
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw ExceptionUtils.mpe((String)"Error: Cannot execute saveOrUpdateBatch Method. Cause", (Throwable)e, (Object[])new Object[0]);
        }
        return true;
    }

    public boolean remove(Serializable id) {
        return SqlHelper.retBool((Integer)this.baseMapper.deleteById(id));
    }

    public boolean remove(T entity) {
        QueryWrapper queryWrapper = new QueryWrapper(entity);
        return SqlHelper.retBool((Integer)this.baseMapper.delete((Wrapper)queryWrapper));
    }

    @Override
    public boolean remove(Collection<? extends Serializable> idList) {
        return SqlHelper.retBool((Integer)this.baseMapper.deleteBatchIds(idList));
    }

    public boolean remove(Map<String, Object> columnMap) {
        if (ObjectUtils.isEmpty(columnMap)) {
            throw ExceptionUtils.mpe((String)"removeByMap columnMap is empty.", (Object[])new Object[0]);
        }
        return SqlHelper.retBool((Integer)this.baseMapper.deleteByMap(columnMap));
    }

    @Override
    public boolean remove(Wrapper<T> wrapper) {
        return SqlHelper.retBool((Integer)this.baseMapper.delete(wrapper));
    }

    public boolean update(T entity) {
        return SqlHelper.retBool((Integer)this.baseMapper.updateById(entity));
    }

    @Override
    public boolean update(T entity, Wrapper<T> updateWrapper) {
        return SqlHelper.retBool((Integer)this.baseMapper.update(entity, updateWrapper));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean update(Collection<T> entityList) {
        return this.update(entityList, 30);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean update(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int i = 0;
            String sqlStatement = this.sqlStatement(SqlMethod.UPDATE_BY_ID);
            for (Entity anEntityList : entityList) {
                MapperMethod.ParamMap param = new MapperMethod.ParamMap();
                param.put((Object)"et", (Object)anEntityList);
                batchSqlSession.update(sqlStatement, (Object)param);
                if (i >= 1 && i % batchSize == 0) {
                    batchSqlSession.flushStatements();
                }
                ++i;
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw ExceptionUtils.mpe((String)"Error: Cannot execute updateBatchById Method. Cause", (Throwable)e, (Object[])new Object[0]);
        }
        return true;
    }

    public T find(Serializable id) {
        return (T)((Entity)this.baseMapper.selectById(id));
    }

    public List<T> find(T entity) {
        QueryWrapper queryWrapper = new QueryWrapper(entity);
        return this.baseMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<T> find(Collection<? extends Serializable> idList) {
        return this.baseMapper.selectBatchIds(idList);
    }

    public List<T> find(Map<String, Object> columnMap) {
        return this.baseMapper.selectByMap(columnMap);
    }

    @Override
    public List<T> find(Wrapper<T> queryWrapper) {
        return this.baseMapper.selectList(queryWrapper);
    }

    @Override
    public T findOne(Wrapper<T> queryWrapper) {
        return (T)((Entity)this.baseMapper.selectOne(queryWrapper));
    }

    @Override
    public Map<String, Object> findMap(Wrapper<T> queryWrapper) {
        List list = this.baseMapper.selectMaps(queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            int size = list.size();
            if (size > 1) {
                this.logger.warn(String.format("Warn: execute Method There are  %s results.", size));
            }
            return (Map)list.get(0);
        }
        return null;
    }

    @Override
    public List<Object> findObjs(Wrapper<T> queryWrapper) {
        return this.baseMapper.selectObjs(queryWrapper);
    }

    public long count(T entity) {
        QueryWrapper queryWrapper = new QueryWrapper(entity);
        return this.baseMapper.selectCount((Wrapper)queryWrapper).intValue();
    }

    @Override
    public int count(Wrapper<T> queryWrapper) {
        return SqlHelper.retCount((Integer)this.baseMapper.selectCount(queryWrapper));
    }

    @Override
    public Page<T> page(Pageable pageVo) {
        return this.page(pageVo.getCurrent(), pageVo.getSize(), (Wrapper<T>)this.fillWrapper(pageVo));
    }

    @Override
    public Page<T> page(Long current, Long size, Wrapper<T> queryWrapper) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page(((Long)ObjectUtil.defaultIfNull((Object)current, (Object)1L)).longValue(), ((Long)ObjectUtil.defaultIfNull((Object)size, (Object)10L)).longValue());
        IPage result = this.baseMapper.selectPage((IPage)page, queryWrapper);
        Page pageResult = new Page();
        pageResult.setCurrent(Long.valueOf(result.getCurrent()));
        pageResult.setPages(result.getPages());
        pageResult.setRecords(result.getRecords());
        pageResult.setTotal(Long.valueOf(result.getTotal()));
        return pageResult;
    }

    @Override
    public IPage<Map<String, Object>> pageMaps(Long current, Long size, Wrapper<T> queryWrapper) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page(current.longValue(), size.longValue());
        return this.baseMapper.selectMapsPage((IPage)page, queryWrapper);
    }

    protected QueryWrapper<T> fillWrapper(Pageable pageable) {
        QueryWrapper queryWrapper = new QueryWrapper();
        List filters = pageable.getFilters();
        if (CollectionUtils.isNotEmpty((Collection)filters)) {
            String fieldName = null;
            for (Filter filter : filters) {
                fieldName = pageable.getCamelToUnderline() == null || pageable.getCamelToUnderline() != false ? StringUtils.camelToUnderline((String)filter.getProperty()) : filter.getProperty();
                Object value = filter.getValue();
                if (Conditions.eq.name().equals(filter.getOperator().name())) {
                    queryWrapper.eq((Object)fieldName, value);
                    continue;
                }
                if (Conditions.ne.name().equals(filter.getOperator().name())) {
                    queryWrapper.ne((Object)fieldName, value);
                    continue;
                }
                if (Conditions.gt.name().equals(filter.getOperator().name())) {
                    queryWrapper.gt((Object)fieldName, value);
                    continue;
                }
                if (Conditions.lt.name().equals(filter.getOperator().name())) {
                    queryWrapper.lt((Object)fieldName, value);
                    continue;
                }
                if (Conditions.ge.name().equals(filter.getOperator().name())) {
                    queryWrapper.ge((Object)fieldName, value);
                    continue;
                }
                if (Conditions.le.name().equals(filter.getOperator().name())) {
                    queryWrapper.le((Object)fieldName, value);
                    continue;
                }
                if (Conditions.like.name().equals(filter.getOperator().name())) {
                    queryWrapper.like((Object)fieldName, value);
                    continue;
                }
                if (Conditions.in.name().equals(filter.getOperator().name())) {
                    if (value != null && value instanceof Collection) {
                        Collection valueColletion = (Collection)value;
                        if (valueColletion.isEmpty()) continue;
                        queryWrapper.in((Object)fieldName, valueColletion);
                        continue;
                    }
                    queryWrapper.in((Object)fieldName, new Object[]{value});
                    continue;
                }
                if (Conditions.isNull.name().equals(filter.getOperator().name())) {
                    queryWrapper.isNull((Object)fieldName);
                    continue;
                }
                if (!Conditions.isNotNull.name().equals(filter.getOperator().name())) continue;
                queryWrapper.isNotNull((Object)fieldName);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)pageable.getAscs())) {
            List ascs = pageable.getAscs();
            if (pageable.getCamelToUnderline() == null || pageable.getCamelToUnderline().booleanValue()) {
                for (int idx = 0; idx < ascs.size(); ++idx) {
                    ascs.set(idx, StringUtils.camelToUnderline((String)((String)ascs.get(idx))));
                }
            }
            queryWrapper.orderByAsc((Object[])ascs.toArray(new String[ascs.size()]));
        }
        if (CollectionUtils.isNotEmpty((Collection)pageable.getDescs())) {
            List descs = pageable.getDescs();
            if (pageable.getCamelToUnderline() == null || pageable.getCamelToUnderline().booleanValue()) {
                for (int idx = 0; idx < descs.size(); ++idx) {
                    descs.set(idx, StringUtils.camelToUnderline((String)((String)descs.get(idx))));
                }
            }
            queryWrapper.orderByDesc((Object[])descs.toArray(new String[descs.size()]));
        }
        return queryWrapper;
    }
}

