/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.dao.mybatis.support.mybatis;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.dtyunxi.app.ServiceContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTenantHandler
implements TenantLineHandler {
    private static final Logger log = LoggerFactory.getLogger(MyTenantHandler.class);
    private static final List<String> IGNORE_TENANT_TABLES = Arrays.asList("TABLES", "`TABLES`", "`COLUMNS`", "COLUMNS");
    private final List<String> ignoreTenantTables;

    public MyTenantHandler(@Nullable List<String> ignoreTenantTables) {
        if (ObjectUtil.isNotEmpty(ignoreTenantTables)) {
            this.ignoreTenantTables = new ArrayList<String>();
            for (String ignoreTenantTable : ignoreTenantTables) {
                this.ignoreTenantTables.add(ignoreTenantTable.toUpperCase());
            }
            this.ignoreTenantTables.addAll(IGNORE_TENANT_TABLES);
        } else {
            this.ignoreTenantTables = IGNORE_TENANT_TABLES;
        }
    }

    public Expression getTenantId() {
        return new LongValue(((Long)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestTenantId(), (Object)-1L)).longValue());
    }

    public boolean ignoreTable(String tableName) {
        boolean result = this.ignoreTenantTables.contains(tableName.toUpperCase());
        if (log.isInfoEnabled()) {
            log.info("\u662f\u5426\u4e3a\u5ffd\u7565\u8868\uff1a{},\u7ed3\u679c\uff1a{}", (Object)tableName, (Object)result);
        }
        return result;
    }
}

