/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datasource;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.DbType;
import com.alibaba.druid.filter.FilterManager;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.dtyunxi.huieryun.vo.DataSourceVo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidDataSourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(DruidDataSourceHelper.class);
    private static final Map<String, String> JDBC_PARAMS = new HashMap<String, String>();

    public static DruidDataSource createDruidDataSource(DataSourceVo dataSourceVo, String connectionProperties, boolean mergeSql) throws SQLException {
        DbType dataSourceDbType;
        if (logger.isDebugEnabled()) {
            logger.debug("Set data source as {}", (Object)dataSourceVo);
        }
        String jdbcUrl = dataSourceVo.getJdbcUrl();
        if (null == dataSourceVo || StringUtils.isBlank((CharSequence)jdbcUrl)) {
            throw new IllegalArgumentException("\u6570\u636e\u94fe\u63a5\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01");
        }
        DruidDataSource dataSource = new DruidDataSource();
        HashMap<String, String> jdbcParams = new HashMap<String, String>(JDBC_PARAMS);
        if (jdbcUrl.contains("?")) {
            int index = jdbcUrl.indexOf(63);
            String params = jdbcUrl.substring(index + 1);
            Stream.of(params.split("&")).map(s -> s.split("=")).forEach(s -> {
                if (!JDBC_PARAMS.containsKey(s[0])) {
                    jdbcParams.put(s[0], s[1]);
                }
            });
            jdbcUrl = jdbcUrl.substring(0, index);
        }
        if (dataSourceVo.isUseSSL()) {
            jdbcParams.put("useSSL", "true");
        } else {
            jdbcParams.put("useSSL", "false");
        }
        String dbType = null;
        String[] jdbcUrlArray = jdbcUrl.split(":");
        if (jdbcUrl.startsWith("jdbc:p6spy")) {
            dbType = jdbcUrlArray[2];
        } else {
            dbType = jdbcUrlArray[1];
            if (dataSourceVo.isUseP6spy()) {
                jdbcUrl = jdbcUrl.replaceFirst("jdbc", "jdbc:p6spy");
                dataSource.setDriverClassName("com.p6spy.engine.spy.P6SpyDriver");
            } else {
                dataSource.setDriverClassName(dataSourceVo.getDriverClassName());
            }
        }
        int index = jdbcUrl.lastIndexOf(47);
        String defaultCatalog = null;
        if (StrUtil.isNotBlank((CharSequence)dataSourceVo.getDatabaseCatalog())) {
            defaultCatalog = dataSourceVo.getDatabaseCatalog();
        } else if (index != 0 && index != jdbcUrl.length()) {
            defaultCatalog = jdbcUrl.substring(index + 1);
            dataSourceVo.setDatabaseCatalog(defaultCatalog);
        }
        jdbcUrl = jdbcUrl + "?" + jdbcParams.entrySet().stream().map(s -> (String)s.getKey() + "=" + (String)s.getValue()).collect(Collectors.joining("&"));
        dataSource.setUrl(jdbcUrl);
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getJdbcUserName())) {
            dataSource.setUsername(dataSourceVo.getJdbcUserName());
        }
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getJdbcUserPassword())) {
            dataSource.setPassword(dataSourceVo.getJdbcUserPassword());
        }
        if ((dataSourceDbType = (DbType)ObjectUtil.defaultIfNull((Object)DbType.valueOf((String)dbType), (Object)DbType.mysql)) == DbType.highgo) {
            dataSource.setDbType(DbType.postgresql);
        } else {
            dataSource.setDbType(dataSourceDbType);
        }
        dataSource.setDbType((DbType)ObjectUtil.defaultIfNull((Object)DbType.valueOf((String)dbType), (Object)DbType.mysql));
        dataSource.setInitialSize(dataSourceVo.getInitialSize());
        dataSource.setMaxActive(dataSourceVo.getMaxActive());
        dataSource.setMinIdle(dataSourceVo.getMinIdle());
        dataSource.setMaxWait((long)dataSourceVo.getMaxWait());
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getValidationQuery())) {
            dataSource.setValidationQuery(dataSourceVo.getValidationQuery());
        }
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setTestWhileIdle(true);
        dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        dataSource.setMinEvictableIdleTimeMillis(25200000L);
        dataSource.setRemoveAbandoned(true);
        dataSource.setRemoveAbandonedTimeout(1800);
        dataSource.setLogAbandoned(true);
        dataSource.setDefaultCatalog(defaultCatalog);
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getDruidFilters())) {
            String filters = dataSourceVo.getDruidFilters();
            if (filters.startsWith("!")) {
                filters = filters.substring(1);
            }
            String[] filterArray = filters.split("\\,");
            CopyOnWriteArrayList filterList = new CopyOnWriteArrayList();
            for (int i = 0; i < filterArray.length; ++i) {
                String filter = filterArray[i].trim();
                FilterManager.loadFilter(filterList, (String)filter);
                if (filter.equals("wall")) {
                    WallFilter wallFilter = (WallFilter)filterList.get(i);
                    WallConfig config = new WallConfig();
                    config.setMultiStatementAllow(true);
                    wallFilter.setConfig(config);
                }
                if (!filter.equals("slf4j")) continue;
                Slf4jLogFilter slf4jLogFilter = (Slf4jLogFilter)filterList.get(i);
                slf4jLogFilter.setConnectionLogEnabled(false);
                slf4jLogFilter.setResultSetLogEnabled(false);
                slf4jLogFilter.setStatementLogEnabled(false);
                slf4jLogFilter.setDataSourceLogEnabled(false);
            }
            dataSource.setProxyFilters(filterList);
        }
        if (StringUtils.isNotBlank((CharSequence)connectionProperties)) {
            dataSource.setConnectionProperties(connectionProperties);
        }
        if (!mergeSql) {
            Properties p = new Properties();
            p.setProperty("druid.stat.mergeSql", mergeSql + "");
            p.setProperty("nullCatalogMeansCurrent", "true");
            dataSource.setConnectProperties(p);
        }
        dataSource.init();
        return dataSource;
    }

    static {
        JDBC_PARAMS.put("useUnicode", "true");
        JDBC_PARAMS.put("characterEncoding", "UTF-8");
        JDBC_PARAMS.put("zeroDateTimeBehavior", "convertToNull");
        JDBC_PARAMS.put("allowMultiQueries", "true");
        JDBC_PARAMS.put("serverTimezone", "Asia/Shanghai");
    }
}

