/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class EoUtil {
    private static final Map<String, Class<?>> CLAZZ_GENERIC_TYPES = new ConcurrentHashMap();

    public static Class<?> getEoClass(Class<?> eoMapper) {
        Class<?> entityClass = EoUtil.getGenericClass(eoMapper);
        if (entityClass != null) {
            String eoName = entityClass.getPackage().getName() + "." + StringUtils.delete((String)entityClass.getSimpleName(), (String)"Eo") + "ExtEo";
            try {
                Class<?> extClass = Class.forName(eoName);
                entityClass = extClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return entityClass;
    }

    public static Class<?> getGenericClass(Class<?> clazz) {
        String clazzName = clazz.getName();
        if (CLAZZ_GENERIC_TYPES.containsKey(clazzName)) {
            return CLAZZ_GENERIC_TYPES.get(clazzName);
        }
        Class typeArgument = null;
        Type type = clazz.getGenericSuperclass();
        if (type == null) {
            type = clazz.getGenericInterfaces()[0];
        }
        if (type instanceof ParameterizedType) {
            typeArgument = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            CLAZZ_GENERIC_TYPES.put(clazzName, typeArgument);
        } else {
            Type parentType = ((Class)type).getGenericSuperclass();
            if (parentType instanceof ParameterizedType) {
                typeArgument = (Class)((ParameterizedType)parentType).getActualTypeArguments()[0];
                CLAZZ_GENERIC_TYPES.put(clazzName, typeArgument);
            }
        }
        return typeArgument;
    }
}

