/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.ds.aop;

import com.dtyunxi.huieryun.ds.mapper.DrdsMapper;
import com.dtyunxi.huieryun.interceptor.DrdsTransactionHelper;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=99)
public class DrdsTransactionAspect {
    private static Logger logger = LoggerFactory.getLogger(DrdsTransactionAspect.class);
    @Resource
    private DrdsMapper drdsMapper;

    @Pointcut(value="@annotation(org.springframework.transaction.annotation.Transactional) || @within(org.springframework.transaction.annotation.Transactional)")
    public void transactionAop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="transactionAop()")
    public Object aroundRestController(ProceedingJoinPoint point) throws Throwable {
        logger.info("start DrdsTransactionAspect..");
        Integer started = DrdsTransactionHelper.getDrdsTransactionStartedStatus();
        Integer lastTimeStartingStatus = new Integer(started);
        try {
            DrdsTransactionHelper.setDrdsTransactionStartedStatus(DrdsTransactionHelper.SETTING_STATUS_AOP);
        }
        finally {
            try {
                Object object = point.proceed();
                return object;
            }
            finally {
                if (DrdsTransactionHelper.SETTING_STATUS_INITIAL.equals(lastTimeStartingStatus)) {
                    DrdsTransactionHelper.clearDrdsTransactionStartedStatus();
                }
            }
        }
    }
}

