/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.dtyunxi.huieryun.vo.DataSourceVo;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidDataSourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(DruidDataSourceHelper.class);

    public static DruidDataSource createDruidDataSource(DataSourceVo dataSourceVo, String connectionProperties) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("Set data source as {}", (Object)dataSourceVo);
        }
        if (null == dataSourceVo || StringUtils.isBlank((CharSequence)dataSourceVo.getJdbcUrl())) {
            throw new IllegalArgumentException("\u6570\u636e\u94fe\u63a5\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff01");
        }
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(dataSourceVo.getJdbcUrl());
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getJdbcUserName())) {
            dataSource.setUsername(dataSourceVo.getJdbcUserName());
        }
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getJdbcUserPassword())) {
            dataSource.setPassword(dataSourceVo.getJdbcUserPassword());
        }
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getDriverClassName())) {
            dataSource.setDriverClassName(dataSourceVo.getDriverClassName());
        }
        dataSource.setInitialSize(dataSourceVo.getInitialSize());
        dataSource.setMaxActive(dataSourceVo.getMaxActive());
        dataSource.setMinIdle(dataSourceVo.getMinIdle());
        dataSource.setMaxWait((long)dataSourceVo.getMaxWait());
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getValidationQuery())) {
            dataSource.setValidationQuery(dataSourceVo.getValidationQuery());
        }
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setTestWhileIdle(true);
        dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        dataSource.setMinEvictableIdleTimeMillis(25200000L);
        dataSource.setRemoveAbandoned(true);
        dataSource.setRemoveAbandonedTimeout(1800);
        dataSource.setLogAbandoned(true);
        if (StringUtils.isNotBlank((CharSequence)dataSourceVo.getDruidFilters())) {
            dataSource.setFilters(dataSourceVo.getDruidFilters());
        }
        if (StringUtils.isNotBlank((CharSequence)connectionProperties)) {
            dataSource.setConnectionProperties(connectionProperties);
        }
        dataSource.init();
        return dataSource;
    }
}

