/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.ds;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.BaseEoUtil;
import com.dtyunxi.huieryun.ds.IdGenrator;
import com.dtyunxi.huieryun.type.SqlEnum;
import com.dtyunxi.util.SqlUtil;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;

public class SqlTemplate<T extends BaseEo> {
    public String insert(T obj) {
        SQL sql = new SQL();
        sql.INSERT_INTO(BaseEoUtil.tableName(obj.getClass()));
        Long id = obj.getId();
        if (null == obj.getId() || obj.getId().equals(0L)) {
            id = this.getId();
        }
        sql.VALUES(BaseEoUtil.returnInsertColumnsName(obj), BaseEoUtil.returnInsertColumnsDef(obj));
        obj.setId(id);
        return sql.toString();
    }

    private Long getId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = BaseEoUtil.getWorkerId();
        return IdGenrator.nextId(workerId, tenantCode);
    }

    public String insertBatch(Map<String, List<T>> params) {
        List<T> objList = params.get("objList");
        if (objList == null || objList.size() == 0) {
            return "sql error";
        }
        SQL sql = new SQL();
        BaseEo obj = (BaseEo)objList.get(0);
        sql.INSERT_INTO(BaseEoUtil.tableName(obj.getClass()));
        String[] values = new String[objList.size()];
        for (int i = 0; i < objList.size(); ++i) {
            StringBuilder sb = new StringBuilder();
            MessageFormat mf = new MessageFormat(BaseEoUtil.returnInsertColumnsDefBatch((BaseEo)((BaseEo)objList.get(i))));
            Long id = ((BaseEo)objList.get(i)).getId();
            if (null == ((BaseEo)objList.get(i)).getId() || ((BaseEo)objList.get(i)).getId().equals(0L)) {
                id = this.getId();
            }
            if (i > 0) {
                sb.append("(");
            }
            sb.append(mf.format(new Object[]{String.valueOf(i)}));
            if (i == objList.size() - 1 && sb.charAt(sb.length() - 1) == ')') {
                sb.deleteCharAt(sb.length() - 1);
            }
            values[i] = sb.toString();
            ((BaseEo)objList.get(i)).setId(id);
        }
        sql.INTO_COLUMNS(new String[]{BaseEoUtil.returnInsertColumnsNameBatch(obj.getClass())});
        sql.INTO_VALUES(values);
        return sql.toString();
    }

    public String update(T obj) {
        return this.getUpdateSql(obj, false);
    }

    public String updateSelective(T obj) {
        return this.getUpdateSql(obj, true);
    }

    private String getUpdateSql(T obj, boolean flag) {
        String returnUpdateSet = null;
        returnUpdateSet = flag ? BaseEoUtil.returnUpdateSetNotNull(obj) : BaseEoUtil.returnUpdateSet(obj);
        String idname = BaseEoUtil.idName(obj.getClass());
        SQL sql = new SQL();
        sql.UPDATE(BaseEoUtil.tableName(obj.getClass()));
        sql.SET(returnUpdateSet);
        sql.WHERE(idname + "= #{" + idname + "}");
        return sql.toString();
    }

    public String updateSelectiveSqlFilter(T obj) {
        SQL sql = new SQL();
        sql.UPDATE(BaseEoUtil.tableName(obj.getClass()));
        sql.SET(BaseEoUtil.returnUpdateSetNotNull(obj));
        String where = BaseEoUtil.returnUpdateWhereColumnNames(obj);
        if (!StringUtils.isNotBlank((CharSequence)where)) {
            return null;
        }
        sql.WHERE(where);
        return sql.toString();
    }

    public String delete(T obj) {
        return this.deleteLogic(obj, false);
    }

    public String deleteLogic(T obj) {
        return this.deleteLogic(obj, true);
    }

    private String deleteLogic(T obj, Boolean isLogicDel) {
        String where = this.getWhere(obj);
        if ("".equals(where)) {
            return null;
        }
        StringBuilder sqlStr = new StringBuilder();
        int dr = isLogicDel == null || isLogicDel != false ? 1 : 2;
        String tableName = BaseEoUtil.tableName(obj.getClass());
        SQL sql = new SQL();
        sql.UPDATE(tableName);
        sql.SET(this.getUpdateCreatePersonDr(dr, obj.getUpdatePerson()));
        sql.WHERE(where);
        sqlStr.append(sql.toString());
        if (isLogicDel != null && !isLogicDel.booleanValue()) {
            sql = new SQL();
            sql.DELETE_FROM(tableName);
            sql.WHERE(where.replace("dr=0", "dr=" + dr));
            sqlStr.append(";").append(sql.toString()).append(";");
        }
        return sqlStr.toString();
    }

    public String deleteLogicById(Class<T> aClass, Long id) {
        return this.deleteLogicId(aClass, id, true);
    }

    public String deleteById(Class<T> aClass, Long id) {
        return this.deleteLogicId(aClass, id, false);
    }

    private String deleteLogicId(Class<T> aClass, Long id, Boolean isLogicDel) {
        int dr = isLogicDel == null || isLogicDel != false ? 1 : 2;
        String tableName = BaseEoUtil.tableName(aClass);
        StringBuilder sqlStr = new StringBuilder();
        SQL sql = new SQL();
        sql.UPDATE(tableName);
        sql.SET(this.getUpdateCreatePersonDr(dr, null));
        sql.WHERE("id = " + id + " and dr = 0");
        sqlStr.append(sql.toString()).append(";");
        if (isLogicDel != null && !isLogicDel.booleanValue()) {
            sql = new SQL();
            sql.DELETE_FROM(tableName);
            sql.WHERE("id = " + id + " and dr = 2");
            sqlStr.append(sql.toString()).append(";");
        }
        return sqlStr.toString();
    }

    public String deleteBatch(Class<T> aClass, Long[] ids) {
        if (ids != null && ids.length == 1) {
            return this.deleteLogicId(aClass, ids[0], false);
        }
        return this.deleteLogicBatchIds(aClass, ids, false);
    }

    public String deleteLogicBatchIds(Class<T> aClass, Long[] ids) {
        if (ids != null && ids.length == 1) {
            return this.deleteLogicId(aClass, ids[0], true);
        }
        return this.deleteLogicBatchIds(aClass, ids, true);
    }

    private String deleteLogicBatchIds(Class<T> aClass, Long[] ids, Boolean isLogicDel) {
        if (ids == null || ids.length < 1) {
            return null;
        }
        String idStr = StringUtils.join((Object[])ids, (String)",");
        int dr = isLogicDel == null || isLogicDel != false ? 1 : 2;
        String tableName = BaseEoUtil.tableName(aClass);
        StringBuilder sqlStr = new StringBuilder();
        SQL sql = new SQL();
        sql.UPDATE(tableName);
        sql.SET(this.getUpdateCreatePersonDr(dr, null));
        sql.WHERE("id in (" + idStr + ") and dr = 0");
        sqlStr.append(sql.toString()).append(";");
        if (isLogicDel != null && !isLogicDel.booleanValue()) {
            sql = new SQL();
            sql.DELETE_FROM(tableName);
            sql.WHERE("id in (" + idStr + ") and dr = 2");
            sqlStr.append(sql.toString()).append(";");
        }
        return sqlStr.toString();
    }

    private String getUpdateCreatePersonDr(int dr, String updatePerson) {
        StringBuilder sb = new StringBuilder();
        sb.append("dr=").append(dr).append(",update_time=now()");
        String reqUupdatePerson = ServiceContext.getContext().getRequestUserCode();
        if (StringUtils.isEmpty((CharSequence)reqUupdatePerson) && StringUtils.isNotEmpty((CharSequence)updatePerson)) {
            reqUupdatePerson = updatePerson;
        }
        if (StringUtils.isNotEmpty((CharSequence)reqUupdatePerson)) {
            sb.append(",update_person='").append(reqUupdatePerson).append("'");
        }
        return sb.toString();
    }

    public String find(T obj) {
        SQL sql = new SQL();
        sql.SELECT(this.getSelectColumnNames(obj, new String[0]));
        sql.FROM(BaseEoUtil.tableName(obj.getClass()));
        String where = this.getWhere(obj);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            sql.WHERE(where);
        } else {
            sql.WHERE("dr = 0");
        }
        return sql.toString();
    }

    public String findColumn(T obj, String ... tableColumnName) {
        SQL sql = new SQL();
        sql.SELECT(this.getSelectColumnNames(obj, tableColumnName));
        sql.FROM(BaseEoUtil.tableName(obj.getClass()));
        String where = this.getWhereFormArg0(obj);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            sql.WHERE(where);
        } else {
            sql.WHERE("dr = 0");
        }
        return sql.toString();
    }

    public String findIdBySqlFilter(T obj) {
        SQL sql = new SQL();
        sql.SELECT("id");
        sql.FROM(BaseEoUtil.tableName(obj.getClass()));
        String where = BaseEoUtil.returnUpdateWhereColumnNames(obj);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            sql.WHERE(where);
            return sql.toString();
        }
        return null;
    }

    public String findList(T obj) {
        SQL sql = new SQL();
        sql.SELECT(this.getSelectColumnNames(obj, new String[0]));
        sql.FROM(BaseEoUtil.tableName(obj.getClass()));
        String where = this.getWhere(obj);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            sql.WHERE(where);
        } else {
            sql.WHERE("dr = 0");
        }
        String orderBy = BaseEoUtil.resultOrderBy(obj);
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            sql.ORDER_BY(orderBy);
        }
        return sql.toString();
    }

    public String findListColumn(T obj, String ... tableColumnName) {
        SQL sql = new SQL();
        sql.SELECT(this.getSelectColumnNames(obj, tableColumnName));
        sql.FROM(BaseEoUtil.tableName(obj.getClass()));
        String where = this.getWhereFormArg0(obj);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            sql.WHERE(where);
        } else {
            sql.WHERE("dr = 0");
        }
        String orderBy = BaseEoUtil.resultOrderBy(obj);
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            sql.ORDER_BY(orderBy);
        }
        return sql.toString();
    }

    public String findPageList(T obj, Integer currentPage, Integer pageSize, SqlEnum sqlEnum) {
        currentPage = currentPage != null ? (currentPage > 0 ? currentPage - 1 : currentPage) : 1;
        pageSize = pageSize != null ? pageSize : 10;
        int pageNo = currentPage * pageSize;
        StringBuilder strBuilder = new StringBuilder();
        boolean bool = false;
        if (sqlEnum != null && sqlEnum.equals((Object)SqlEnum.postgreSql)) {
            strBuilder.append(" limit ").append(pageSize).append(" offset ").append(pageNo);
            bool = true;
        }
        if (!bool) {
            strBuilder.append(" limit ").append(pageNo).append(",").append(pageSize);
        }
        String sql = this.findListColumn(obj, new String[0]);
        return sql + strBuilder.toString();
    }

    public String findById(Class<T> aClass, Long id) {
        return this.findColumnById(aClass, id, new String[0]);
    }

    public String findByIdsDr(Class<T> aClass, Long[] ids, Boolean containsDr) {
        return this.findColumnByIdsDr(aClass, ids, containsDr, new String[0]);
    }

    public String findColumnByIdsDr(Class<T> aClass, Long[] ids, Boolean containsDr, String ... tableColumnName) {
        String selectColumnName = null;
        if (tableColumnName != null && tableColumnName.length > 0) {
            selectColumnName = StringUtils.join((Object[])tableColumnName, (String)",").toLowerCase();
            if (!SqlUtil.isSpiteParams((String)selectColumnName)) {
                selectColumnName = BaseEoUtil.returnSelectColumnsName(aClass);
            }
        } else {
            selectColumnName = BaseEoUtil.returnSelectColumnsName(aClass);
        }
        SQL sql = new SQL();
        sql.SELECT(selectColumnName);
        sql.FROM(BaseEoUtil.tableName(aClass));
        String idname = BaseEoUtil.idName(aClass);
        String where = null;
        where = ids.length == 1 ? idname + " = " + ids[0] : idname + " in (" + StringUtils.join((Object[])ids, (String)",") + ")";
        if (!containsDr.booleanValue()) {
            where = where + " and dr=0";
        }
        sql.WHERE(where);
        return sql.toString();
    }

    public String findColumnById(Class<T> aClass, Long id, String ... tableColumnName) {
        String selectColumnName = null;
        if (tableColumnName != null && tableColumnName.length > 0) {
            selectColumnName = StringUtils.join((Object[])tableColumnName, (String)",").toLowerCase();
            if (!SqlUtil.isSpiteParams((String)selectColumnName)) {
                selectColumnName = BaseEoUtil.returnSelectColumnsName(aClass);
            }
        } else {
            selectColumnName = BaseEoUtil.returnSelectColumnsName(aClass);
        }
        SQL sql = new SQL();
        sql.SELECT(selectColumnName);
        sql.FROM(BaseEoUtil.tableName(aClass));
        String idname = BaseEoUtil.idName(aClass);
        sql.WHERE(idname + " = " + id + " and dr=0");
        return sql.toString();
    }

    public String findAll(Class<T> aClass) {
        SQL sql = new SQL();
        sql.SELECT(BaseEoUtil.returnSelectColumnsName(aClass));
        sql.FROM(BaseEoUtil.tableName(aClass));
        sql.WHERE("dr = 0");
        return sql.toString();
    }

    public String count(Class<T> aClass) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(BaseEoUtil.tableName(aClass));
        sql.WHERE("dr = 0");
        return sql.toString();
    }

    public String countCondition(T obj) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(BaseEoUtil.tableName(obj.getClass()));
        String where = this.getWhere(obj);
        if (StringUtils.isNotBlank((CharSequence)where)) {
            sql.WHERE(this.getWhere(obj));
        } else {
            sql.WHERE("dr = 0");
        }
        return sql.toString();
    }

    private String getSelectColumnNames(T obj, String ... tableColumnName) {
        String selectColumnName = null;
        if (tableColumnName != null && tableColumnName.length > 0) {
            selectColumnName = StringUtils.join((Object[])tableColumnName, (String)",").toLowerCase();
            if (!SqlUtil.isSpiteParams((String)selectColumnName)) {
                selectColumnName = BaseEoUtil.returnSelectColumnsName(obj.getClass());
            }
        } else {
            selectColumnName = BaseEoUtil.returnSelectColumnsName(obj.getClass());
        }
        return selectColumnName;
    }

    private String getWhere(T obj) {
        StringBuilder where = new StringBuilder();
        where.append(BaseEoUtil.returnWhereColumnNames(obj, (boolean)false));
        if (obj.getId() != null) {
            where.append(" and id = #{id}");
        }
        if (StringUtils.isNotEmpty((CharSequence)obj.getCreatePerson())) {
            where.append(" and create_person = #{createPerson}");
        }
        if (StringUtils.isNotEmpty((CharSequence)obj.getUpdatePerson())) {
            where.append(" and update_person = #{updatePerson}");
        }
        if (obj.getTenantId() != null) {
            where.append(" and tenant_id = #{tenantId}");
        }
        if (obj.getInstanceId() != null) {
            where.append(" and instance_id = #{instanceId}");
        }
        return where.toString();
    }

    private String getWhereFormArg0(T obj) {
        StringBuilder where = new StringBuilder();
        where.append(BaseEoUtil.returnWhereColumnNames(obj, (boolean)true));
        if (obj.getId() != null) {
            where.append(" and id = #{arg0.id}");
        }
        if (StringUtils.isNotEmpty((CharSequence)obj.getCreatePerson())) {
            where.append(" and create_person = #{arg0.createPerson}");
        }
        if (StringUtils.isNotEmpty((CharSequence)obj.getUpdatePerson())) {
            where.append(" and update_person = #{arg0.updatePerson}");
        }
        if (obj.getTenantId() != null) {
            where.append(" and tenant_id = #{arg0.tenantId}");
        }
        if (obj.getInstanceId() != null) {
            where.append(" and instance_id = #{arg0.instanceId}");
        }
        return where.toString();
    }
}

