/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datasource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataSourceRoutingStrategy {
    private static final ThreadLocal<Boolean> isUseSlave = new ThreadLocal();
    private int slaveSize = 0;
    private List<String> slaveKeys = new ArrayList<String>();
    private int nextSlave = 0;

    public void addSlaveKeys(Collection<String> slaveKeys) {
        this.slaveKeys.addAll(slaveKeys);
        this.slaveSize = this.slaveKeys.size();
    }

    public boolean isUseSlave() {
        Boolean currentThreadIsUserSlaveCurrent = isUseSlave.get();
        return this.slaveSize != 0 && currentThreadIsUserSlaveCurrent != null && currentThreadIsUserSlaveCurrent != false;
    }

    public String findSlaveKey() {
        if (this.slaveSize == 0) {
            return null;
        }
        return this.slaveKeys.get(this.nextSlave());
    }

    private synchronized int nextSlave() {
        ++this.nextSlave;
        if (this.nextSlave >= this.slaveSize) {
            this.nextSlave = 0;
        }
        return this.nextSlave;
    }

    public static void setUseSlave(boolean useSlave) {
        isUseSlave.set(useSlave);
    }
}

