/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.aop;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.datalimit.service.IMetaDataQueryService;
import com.dtyunxi.huieryun.datalimit.utils.ControlledEntityHolder;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitContext;
import com.dtyunxi.huieryun.datalimit.utils.DataLimitRuleHandler;
import com.dtyunxi.huieryun.util.EoUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Table;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Aspect
public class DataLimitAspect {
    private static final Logger logger = LoggerFactory.getLogger(DataLimitAspect.class);
    private DataLimitRuleHandler dataLimitRuleHandler;
    private IMetaDataQueryService metaDataQueryService;
    private static final ThreadLocal<Map<String, Integer>> localStrackMap = new ThreadLocal();
    private static final ThreadLocal<Page<Object>> pageHelperThreadLocal = new ThreadLocal();

    public DataLimitAspect(DataLimitRuleHandler dataLimitRuleHandler, IMetaDataQueryService metaDataQueryService) {
        this.dataLimitRuleHandler = dataLimitRuleHandler;
        this.metaDataQueryService = metaDataQueryService;
    }

    @Around(value="execution(* com.dtyunxi.cube.framework.das.ComBaseDas+.*(..)) && !execution(* com.dtyunxi.cube.framework.das.ComBaseDas+.exists(..))")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> eoClass = EoUtil.getGenericClass(joinPoint.getTarget().getClass());
        if (null == eoClass) {
            throw new IllegalStateException("Das \u7ee7\u627f\u7ed3\u6784\u4e0d\u6807\u51c6\uff01");
        }
        joinPoint.getTarget();
        if (!eoClass.isAnnotationPresent(Table.class)) {
            throw new IllegalStateException(eoClass.getName() + "\u4e2d,Table\u6ce8\u89e3\u4e0d\u5b58\u5728\uff01");
        }
        String tableName = eoClass.getAnnotation(Table.class).name();
        try {
            if (this.metaDataQueryService.isEntityUnderControl(tableName)) {
                this.setDasControl(joinPoint, tableName);
                logger.debug("{} \u662f\u53d7\u63a7\u5bf9\u8c61", (Object)tableName);
                if (this.isAlreadyControl(tableName)) {
                    List<String> subQueryList = this.dataLimitRuleHandler.getDataLimitSQL(eoClass, tableName);
                    if (!CollectionUtils.isEmpty(subQueryList)) {
                        DataLimitContext.addLimitRule(tableName, subQueryList);
                        logger.debug("\u83b7\u53d6\u5230\u89c4\u5219:{}", JSON.toJSON(subQueryList));
                    } else {
                        logger.info("\u53d7\u63a7\u5bf9\u8c61{}\u6ca1\u6709\u83b7\u53d6\u5230\u6570\u636e\u6743\u9650\u89c4\u5219!", (Object)tableName);
                    }
                    this.startPageHelper();
                }
            } else {
                logger.debug("{} \u4e0d\u662f\u53d7\u63a7\u5bf9\u8c61\uff0c\u4e0d\u8fdb\u884c\u6570\u636e\u6743\u9650\u5904\u7406\u3002", (Object)tableName);
            }
            Object[] args = joinPoint.getArgs();
            Object result = joinPoint.proceed(args);
            DataLimitContext.clear();
            Object object = result;
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.clearStack(tableName);
        }
    }

    private void setDasControl(ProceedingJoinPoint joinPoint, String tableName) {
        if (!ControlledEntityHolder.hasTable(tableName)) {
            try {
                ReflectUtil.invoke((Object)joinPoint.getTarget(), (String)"setEntityUnderControl", (Object[])new Object[]{true});
            }
            catch (Exception e) {
                logger.warn("\u8bbe\u7f6eDas\u5bf9\u8c61entityUnderControl\u5c5e\u6027\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bcube-framework-core\u7248\u672c\uff01{}", (Object)e.getMessage());
            }
            ControlledEntityHolder.addTable(tableName);
        }
    }

    private boolean isAlreadyControl(String tableName) {
        Map<String, Integer> stringIntegerMap = localStrackMap.get();
        if (stringIntegerMap == null) {
            Page localPage = PageHelper.getLocalPage();
            if (localPage != null && localPage.getPageNum() > 0) {
                PageHelper.clearPage();
                pageHelperThreadLocal.set((Page<Object>)localPage);
            }
            stringIntegerMap = new HashMap<String, Integer>(16);
            stringIntegerMap.put(tableName, 1);
            localStrackMap.set(stringIntegerMap);
            return true;
        }
        Integer integer = stringIntegerMap.get(tableName);
        if (integer == null || integer == 0) {
            stringIntegerMap.put(tableName, 1);
            return true;
        }
        Integer n = integer;
        Integer n2 = integer = Integer.valueOf(integer + 1);
        stringIntegerMap.put(tableName, integer);
        return false;
    }

    private void clearStack(String key) {
        Map<String, Integer> stringIntegerMap = localStrackMap.get();
        if (stringIntegerMap == null) {
            return;
        }
        Integer integer = stringIntegerMap.get(key);
        if (integer != null) {
            if (integer > 1) {
                Integer n = integer;
                Integer n2 = integer = Integer.valueOf(integer - 1);
                stringIntegerMap.put(key, integer);
            } else {
                stringIntegerMap.remove(key);
            }
        }
        if (stringIntegerMap.isEmpty()) {
            localStrackMap.remove();
        }
    }

    private void startPageHelper() {
        Page<Object> objects;
        Map<String, Integer> stringIntegerMap = localStrackMap.get();
        if (stringIntegerMap != null && stringIntegerMap.size() == 1 && (objects = pageHelperThreadLocal.get()) != null && objects.getPageNum() > 0) {
            PageHelper.startPage((int)objects.getPageNum(), (int)objects.getPageSize(), (boolean)objects.isCount(), (Boolean)objects.getReasonable(), (Boolean)objects.getPageSizeZero());
            pageHelperThreadLocal.remove();
        }
    }
}

