/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.utils;

import com.dtyunxi.app.ServiceContext;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class FunctionHandler
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static Logger logger = LoggerFactory.getLogger(FunctionHandler.class);
    private static Set<Class<?>> allowedTypeSet = new HashSet();

    public String replaceFunctionWithValue(String dataLimitStr) {
        if (!dataLimitStr.contains("FUN_START")) {
            return dataLimitStr;
        }
        Long userId = ServiceContext.getContext().getRequestUserId();
        String rule = dataLimitStr.replace("CURRENT_USER_ID", String.valueOf(userId));
        Map<String, Function> functionMap = this.getFunctionMap(rule);
        String result = this.replaceValueWithFunctionCall(dataLimitStr, functionMap);
        logger.debug("\u66ff\u6362\u51fd\u6570\u7ed3\u679c\u540e\u7684\u89c4\u5219:{}", (Object)result);
        return result;
    }

    private String replaceValueWithFunctionCall(String dataLimitStr, Map<String, Function> functionMap) {
        if (CollectionUtils.isEmpty(functionMap)) {
            return null;
        }
        Long userId = ServiceContext.getContext().getRequestUserId();
        String rule = dataLimitStr.replace("CURRENT_USER_ID", String.valueOf(userId));
        Set<Map.Entry<String, Function>> entrySet = functionMap.entrySet();
        for (Map.Entry<String, Function> entry : entrySet) {
            Object callResult = this.callFunction(entry.getValue());
            if (null == callResult) {
                return "1!=1";
            }
            String result = this.convertResult2String(callResult);
            if (StringUtils.isEmpty((Object)result)) {
                return "1!=1";
            }
            rule = rule.replace(entry.getKey(), result);
        }
        return rule;
    }

    private Object callFunction(Function function) {
        Object object = this.getBeanByName(function.getBeanName());
        Class<?> clz = object.getClass();
        Method method = this.getMethod(function, clz.getDeclaredMethods());
        if (null == method) {
            throw new IllegalStateException("\u627e\u4e0d\u5230\u51fd\u6570\uff1a" + function.getBeanName() + "." + function.getMethod() + ",\u8bf7\u786e\u8ba4\u51fd\u6570\u662f\u5426\u5728\u8be5\u7c7b\u4e2d\u5b9a\u4e49\uff0c\u5982\u679c\u662f\u7528\u6237\u4e2d\u5fc3\u901a\u7528\u51fd\u6570\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u4e2d\u5fc3jar\u5305\u7248\u672c\uff01");
        }
        method.setAccessible(true);
        Object[] params = this.getParam(method.getParameterTypes(), function.getParamList());
        return ReflectionUtils.invokeMethod((Method)method, (Object)object, (Object[])params);
    }

    private Object getBeanByName(String beanName) {
        Object object;
        try {
            object = this.applicationContext.getBean(beanName);
        }
        catch (BeansException e) {
            beanName = beanName.substring(beanName.lastIndexOf(".") + 1);
            beanName = beanName.substring(0, 1).toLowerCase() + beanName.substring(1);
            try {
                object = this.applicationContext.getBean(beanName);
            }
            catch (BeansException be) {
                beanName = beanName.substring(1).substring(0, 1).toLowerCase() + beanName.substring(2);
                object = this.applicationContext.getBean(beanName);
            }
        }
        return object;
    }

    private Method getMethod(Function function, Method[] methods) {
        for (Method m : methods) {
            if (!m.getName().equals(function.getMethod()) || m.getParameterCount() != function.getParamList().size()) continue;
            return m;
        }
        return null;
    }

    private String convertResult2String(Object object) {
        String result;
        Object resultDataObject;
        try {
            Method getDataMethod = object.getClass().getDeclaredMethod("getData", new Class[0]);
            resultDataObject = getDataMethod.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        StringBuilder valueBuilder = new StringBuilder();
        if (resultDataObject instanceof List) {
            boolean isNumeric;
            if (((List)resultDataObject).size() == 0) {
                return valueBuilder.toString();
            }
            Object item = ((List)resultDataObject).get(0);
            if (item instanceof Integer || item instanceof Long || item instanceof Float || item instanceof Double) {
                isNumeric = true;
            } else if (item instanceof String) {
                isNumeric = false;
            } else {
                throw new IllegalArgumentException("");
            }
            List list = (List)resultDataObject;
            for (Object obj : list) {
                if (isNumeric) {
                    valueBuilder.append(obj).append(",");
                    continue;
                }
                valueBuilder.append("'").append(obj).append("',");
            }
            result = valueBuilder.substring(0, valueBuilder.length());
        } else if (resultDataObject instanceof Integer || resultDataObject instanceof Long || resultDataObject instanceof Float || resultDataObject instanceof Double || resultDataObject instanceof String) {
            result = resultDataObject.toString();
        } else {
            throw new IllegalArgumentException();
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        result = "(" + result + ")";
        logger.debug("\u89e3\u6790\u540e\u7684\u51fd\u6570\u8c03\u7528\u7ed3\u679c:{}", (Object)result);
        return result;
    }

    private Map<String, Function> getFunctionMap(String rule) {
        HashMap<String, Function> functionMap = new HashMap<String, Function>(32);
        String allRule = rule;
        while (allRule.contains("FUN_START")) {
            int fragmentStartIndex = allRule.indexOf("FUN_START");
            int fragmentEndIndex = allRule.indexOf("FUN_END") + "FUN_END".length();
            if (fragmentStartIndex <= -1 || fragmentEndIndex <= -1) continue;
            String funcFragmentStr = allRule.substring(fragmentStartIndex, fragmentEndIndex);
            String funcStr = funcFragmentStr.substring("FUN_START".length(), funcFragmentStr.indexOf("FUN_END")).trim();
            functionMap.put(funcFragmentStr, this.getFunc(funcStr));
            allRule = allRule.replaceFirst("FUN_START(.*?)FUN_END", "");
        }
        return functionMap;
    }

    private Function getFunc(String funcStr) {
        int dotIndex = funcStr.lastIndexOf(".");
        String beanName = funcStr.substring(0, dotIndex);
        String method = funcStr.substring(dotIndex + 1, funcStr.indexOf("("));
        String paramStr = funcStr.substring(funcStr.indexOf("(") + 1, funcStr.indexOf(")"));
        List<Object> paramList = !StringUtils.isEmpty((Object)(paramStr = paramStr.replaceAll("\\s*", ""))) ? Arrays.asList(paramStr.split(",")) : Lists.newArrayList();
        logger.debug("\u53d1\u73b0\u51fd\u6570\u89c4\u5219,\u5f00\u59cb\u8c03\u7528\u51fd\u6570\uff1a{}.{}", (Object)beanName, (Object)method);
        return new Function(beanName, method, paramList);
    }

    private Object[] getParam(Class<?>[] parameterTypes, List<String> paramList) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return null;
        }
        Object[] realParam = new Object[parameterTypes.length];
        try {
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (!allowedTypeSet.contains(parameterTypes[i])) continue;
                Class<?> object = Class.forName(parameterTypes[i].getName());
                Class[] constructParam = new Class[]{String.class};
                Constructor<?> constructor = object.getConstructor(constructParam);
                realParam[i] = constructor.newInstance(paramList.get(i));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return realParam;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    static {
        allowedTypeSet.add(Integer.class);
        allowedTypeSet.add(Long.class);
        allowedTypeSet.add(Float.class);
        allowedTypeSet.add(Double.class);
        allowedTypeSet.add(String.class);
    }

    static class Function {
        private String beanName;
        private String method;
        private List<String> paramList;

        Function(String beanName, String method, List<String> paramList) {
            this.beanName = beanName;
            this.method = method;
            this.paramList = paramList;
        }

        String getBeanName() {
            return this.beanName;
        }

        void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        String getMethod() {
            return this.method;
        }

        void setMethod(String method) {
            this.method = method;
        }

        public List<String> getParamList() {
            return this.paramList;
        }

        public void setParamList(List<String> paramList) {
            this.paramList = paramList;
        }
    }
}

