/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datalimit.utils;

import com.dtyunxi.annotation.TableRefInfo;
import com.dtyunxi.huieryun.datalimit.utils.SqlUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RuleResolver {
    private static final Logger log = LoggerFactory.getLogger(RuleResolver.class);

    public List<String> resolve2Sql(Class<?> eoClass, String dataLimitStr) {
        String mainTableCondition;
        if (StringUtils.isEmpty((Object)dataLimitStr)) {
            return Collections.emptyList();
        }
        ArrayList<String> joinRuleList = new ArrayList();
        String commonRule = null;
        if (dataLimitStr.contains("JOIN_START")) {
            joinRuleList = this.getJoinRule(dataLimitStr);
            commonRule = this.removeJoinRule(dataLimitStr);
        } else {
            commonRule = dataLimitStr;
        }
        ArrayList subQueryList = Lists.newArrayList();
        String joinTableCondition = this.parserJoinTableRule(joinRuleList, eoClass);
        if (!StringUtils.isEmpty((Object)joinTableCondition)) {
            subQueryList.add(joinTableCondition);
        }
        if (!StringUtils.isEmpty((Object)(mainTableCondition = this.parserMainTableRule(commonRule, eoClass)))) {
            subQueryList.add(mainTableCondition);
        }
        return subQueryList;
    }

    private String removeJoinRule(String dataLimitStr) {
        String rule = dataLimitStr.toUpperCase();
        String withoutAndReg = "JOIN_START(.*?)JOIN_END";
        String withAndReg = "AND\\s" + withoutAndReg;
        if ((rule = rule.replaceAll(withAndReg, "").replaceAll(withoutAndReg, "")).trim().startsWith("AND")) {
            rule = rule.replace("AND", "");
        }
        return rule;
    }

    private Map<String, Map<String, String>> assembleFiledRefTableMap(Class<?> eoClass) {
        HashMap<String, Map<String, String>> fieldRefTableMap = new HashMap<String, Map<String, String>>(32);
        List<Field> fieldList = this.getAllFieldsIncludeSuper(eoClass);
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(TableRefInfo.class)) continue;
            if (field.isAnnotationPresent(Column.class)) {
                Column column = field.getAnnotation(Column.class);
                this.assembleRefTableMap(fieldRefTableMap, field, column.name());
                continue;
            }
            log.info("{} \u5b57\u6bb5\u6ca1\u6709Column\u6ce8\u89e3", (Object)field.getName());
        }
        return fieldRefTableMap;
    }

    private void assembleRefTableMap(Map<String, Map<String, String>> fieldRefTableMap, Field field, String mainTableField) {
        TableRefInfo tableRefInfo = field.getAnnotation(TableRefInfo.class);
        String refTableName = tableRefInfo.tableName();
        String refColumnName = tableRefInfo.columnName();
        HashMap<String, String> refTableMap = new HashMap<String, String>(16);
        refTableMap.put(refTableName, refColumnName);
        fieldRefTableMap.put(mainTableField, refTableMap);
    }

    private List<Field> getAllFieldsIncludeSuper(Class<?> clz) {
        ArrayList fields = Lists.newArrayList();
        do {
            fields.addAll(Lists.newArrayList((Object[])clz.getDeclaredFields()));
        } while (!Object.class.equals(clz = clz.getSuperclass()));
        return fields;
    }

    private List<String> getJoinRule(String rule) {
        ArrayList list = Lists.newArrayList();
        String dataLimitRule = rule.toUpperCase();
        while (dataLimitRule.contains("JOIN_START")) {
            String startSign = dataLimitRule.indexOf("JOIN_START") == 0 ? "JOIN_START" : "AND JOIN_START";
            int joinStartIndex = dataLimitRule.indexOf(startSign);
            int joinEndIndex = dataLimitRule.indexOf("JOIN_END") + "JOIN_END".length();
            if (joinStartIndex <= -1 || joinEndIndex <= -1) continue;
            String joinRuleFragment = dataLimitRule.substring(joinStartIndex, joinEndIndex);
            String joinRule = joinRuleFragment.substring(joinRuleFragment.indexOf("=") + 1, joinRuleFragment.indexOf("JOIN_END"));
            log.debug("\u53d1\u73b0\u5173\u8054\u89c4\u5219:{}", (Object)joinRule);
            list.add(joinRule);
            String reg = startSign + "(.*?)" + "JOIN_END";
            dataLimitRule = dataLimitRule.replaceFirst(reg, "");
            log.debug("\u63d0\u53d6\u5173\u8054\u89c4\u5219\u540e\u7684\u89c4\u5219\uff1a{}", (Object)dataLimitRule);
        }
        return list;
    }

    private String parserJoinTableRule(List<String> joinRuleList, Class<?> eoClass) {
        if (joinRuleList.isEmpty()) {
            return null;
        }
        Map<String, Map<String, String>> refFieldRefTableMap = this.assembleFiledRefTableMap(eoClass);
        Set<Map.Entry<String, Map<String, String>>> entries = refFieldRefTableMap.entrySet();
        ArrayList<String> ruleJoinList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : entries) {
            String joinQuery = SqlUtil.joinRule2Sql(entry, joinRuleList);
            if (StringUtils.isEmpty((Object)joinQuery)) continue;
            ruleJoinList.add(joinQuery);
        }
        if (!ruleJoinList.isEmpty()) {
            return " (" + String.join((CharSequence)" and ", ruleJoinList) + ") ";
        }
        return null;
    }

    private String parserMainTableRule(String mainTableRule, Class<?> eoClass) {
        if (StringUtils.isEmpty((Object)mainTableRule)) {
            return null;
        }
        return " (" + SqlUtil.getCommonRuleConditon(mainTableRule, eoClass.getAnnotation(Table.class).name()) + ") ";
    }
}

