/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.dtyunxi.huieryun.datasource.DataSourceRoutingStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.AbstractDataSource;

public class DynamicDataSource
extends AbstractDataSource
implements InitializingBean {
    private Map<String, DataSource> slaveDataSources;
    private DataSource masterDataSource;
    private DataSourceRoutingStrategy routingStrategy = new DataSourceRoutingStrategy();

    public void setSlaveDataSources(Map<String, DataSource> slaveDataSources) {
        this.slaveDataSources = slaveDataSources;
    }

    public void setMasterDataSource(DataSource masterDataSource) {
        this.masterDataSource = masterDataSource;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.masterDataSource == null) {
            throw new IllegalArgumentException("Property 'masterDataSource' is required");
        }
        this.routingStrategy.addSlaveKeys(this.slaveDataSources.keySet());
    }

    public Connection getConnection() throws SQLException {
        return this.determineTargetDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineTargetDataSource().getConnection(username, password);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        return this.determineTargetDataSource().unwrap(iface);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance((Object)this) || this.determineTargetDataSource().isWrapperFor(iface);
    }

    protected DataSource determineTargetDataSource() {
        if (!this.routingStrategy.isUseSlave()) {
            return this.masterDataSource;
        }
        String slaveKey = this.routingStrategy.findSlaveKey();
        if (slaveKey == null) {
            return this.masterDataSource;
        }
        return this.slaveDataSources.get(slaveKey);
    }

    public void close() {
        if (this.masterDataSource instanceof DruidDataSource) {
            ((DruidDataSource)this.masterDataSource).close();
        }
        for (DataSource slaveDataSource : this.slaveDataSources.values()) {
            if (!(this.masterDataSource instanceof DruidDataSource)) continue;
            ((DruidDataSource)slaveDataSource).close();
        }
    }
}

