/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.plugin;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.dtyunxi.annotation.ShardingColumn;
import com.dtyunxi.huieryun.plugin.TableNameModifier;
import com.dtyunxi.huieryun.util.EoUtil;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class ShardingTablePlugin
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ShardingTablePlugin.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (!(target instanceof RoutingStatementHandler)) {
            return invocation.proceed();
        }
        RoutingStatementHandler routingStatementHandler = (RoutingStatementHandler)target;
        BoundSql boundSql = routingStatementHandler.getBoundSql();
        MetaObject metaObject = SystemMetaObject.forObject((Object)routingStatementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        Class<?> mapperClass = Class.forName(mappedStatement.getId().substring(0, mappedStatement.getId().lastIndexOf(".")));
        Class<?> eoClass = EoUtil.getEoClass(mapperClass);
        ShardingColumn[] shardingColumns = (ShardingColumn[])eoClass.getAnnotationsByType(ShardingColumn.class);
        if (shardingColumns.length <= 1) {
            return invocation.proceed();
        }
        String sql = boundSql.getSql();
        log.debug("before modify sql={}", (Object)sql);
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLStatement sqlStatement = parser.parseStatement();
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        sqlStatement.accept((SQLASTVisitor)visitor);
        Map tableMap = visitor.getTables();
        if (tableMap.size() > 1) {
            return invocation.proceed();
        }
        String sourceTableName = tableMap.keySet().toArray(new TableStat.Name[1])[0].getName();
        List conditions = visitor.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return invocation.proceed();
        }
        String targetTableName = null;
        for (int i = 1; i < shardingColumns.length; ++i) {
            ShardingColumn shardingColumn = shardingColumns[i];
            for (TableStat.Condition condition : conditions) {
                if (!shardingColumn.name().equalsIgnoreCase(condition.getColumn().getName()) || !StringUtils.isNotBlank((CharSequence)(targetTableName = shardingColumn.table()))) continue;
                break;
            }
            if (StringUtils.isNotBlank(targetTableName)) break;
        }
        if (StringUtils.isNotBlank(targetTableName)) {
            if (!sourceTableName.equals(targetTableName)) {
                TableNameModifier tableNameModifier = new TableNameModifier(sourceTableName, targetTableName);
                sqlStatement.accept((SQLASTVisitor)tableNameModifier);
            }
            StringBuffer buf = new StringBuffer();
            sqlStatement.output(buf);
            sql = buf.toString();
            metaObject = SystemMetaObject.forObject((Object)boundSql);
            metaObject.setValue("sql", (Object)sql);
        }
        log.debug("after modify sql={}", (Object)sql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

