/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.transaction;

import com.alibaba.druid.pool.DruidDataSource;
import com.dtyunxi.huieryun.transaction.DrdsTransactionPolicy;
import com.dtyunxi.lang.BusinessRuntimeException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class DrdsTransactionManager
extends DataSourceTransactionManager {
    private static final long serialVersionUID = -8925425663858863783L;
    private DrdsTransactionPolicy transactionPolicy = DrdsTransactionPolicy.FLEXIBLE;
    private boolean drdsDb = false;

    public boolean isDrdsDb() {
        return this.drdsDb;
    }

    public void setDrdsDb(boolean drdsDb) {
        this.drdsDb = drdsDb;
    }

    public DrdsTransactionManager(DataSource dataSource) {
        super(dataSource);
        DruidDataSource druidDataSource;
        if (dataSource instanceof DruidDataSource && (druidDataSource = (DruidDataSource)dataSource).getRawJdbcUrl().contains("drds.aliyuncs.com")) {
            this.drdsDb = true;
        }
    }

    public DrdsTransactionManager(DataSource dataSource, boolean drdsDb) {
        super(dataSource);
        this.drdsDb = drdsDb;
    }

    protected void prepareTransactionalConnection(Connection con, TransactionDefinition definition) throws SQLException {
        if (!this.drdsDb) {
            super.prepareTransactionalConnection(con, definition);
            return;
        }
        try (Statement stmt = con.createStatement();){
            switch (this.transactionPolicy) {
                case FREE: {
                    stmt.executeUpdate("SET drds_transaction_policy = 'FREE'");
                    break;
                }
                case TWO_PC: {
                    stmt.executeUpdate("SET drds_transaction_policy = '2PC'");
                    break;
                }
                case XA: {
                    stmt.executeUpdate("SET drds_transaction_policy = 'XA'");
                    break;
                }
                default: {
                    stmt.executeUpdate("SET drds_transaction_policy = 'FLEXIBLE'");
                }
            }
            super.prepareTransactionalConnection(con, definition);
        }
    }

    public final DrdsTransactionPolicy getTransactionPolicy() {
        return this.transactionPolicy;
    }

    public final void setTransactionPolicy(DrdsTransactionPolicy transactionPolicy) {
        if (transactionPolicy == null) {
            throw new BusinessRuntimeException("DRDS \u4e8b\u52a1\u7b56\u7565\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        this.transactionPolicy = transactionPolicy;
    }
}

