/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datadistribute;

import com.dtyunxi.huieryun.datadistribute.DataDistributeClient;
import com.dtyunxi.huieryun.datadistribute.constant.DataDistributeProviderEnum;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public final class DataDistributeClientFactory {
    @Autowired
    private ApplicationContext applicationContext;
    private static final String CANAL_CLIENT_BEAN_NAME = "canalDataDistributeClient";
    private static final String DTS_CLIENT_BEAN_NAME = "dtsDataDistributeClient";
    private static final String DRS_CLIENT_BEAN_NAME = "drsDataDistributeClient";
    private static final String LOGSHIPPER_CLIENT_BEAN_NAME = "logShipperDataDistributeClient";
    private static final String DTS_KAFKA_CLIENT_BEAN_NAME = "dtsKafkaDataDistributeClient";
    private final DataDistributeProviderEnum clientProvider;
    private Map<DataDistributeProviderEnum, String> clientConfigToSpringName = new HashMap<DataDistributeProviderEnum, String>(){
        {
            this.put(DataDistributeProviderEnum.CANAL, DataDistributeClientFactory.CANAL_CLIENT_BEAN_NAME);
            this.put(DataDistributeProviderEnum.DTS, DataDistributeClientFactory.DTS_CLIENT_BEAN_NAME);
            this.put(DataDistributeProviderEnum.DRS, DataDistributeClientFactory.DRS_CLIENT_BEAN_NAME);
            this.put(DataDistributeProviderEnum.LOGSHIPPER, DataDistributeClientFactory.LOGSHIPPER_CLIENT_BEAN_NAME);
            this.put(DataDistributeProviderEnum.DTS_KAFKA, DataDistributeClientFactory.DTS_KAFKA_CLIENT_BEAN_NAME);
        }
    };

    public DataDistributeClientFactory() {
        this.clientProvider = DataDistributeProviderEnum.getDataDistributeProvider();
    }

    public DataDistributeClientFactory(DataDistributeProviderEnum clientProvider) {
        this.clientProvider = clientProvider;
    }

    public DataDistributeClient getClient() {
        if (this.clientProvider == null) {
            throw new IllegalArgumentException("\u6570\u636e\u5206\u53d1\u8ba2\u9605\u5ba2\u6237\u7aef\u914d\u7f6e\u9519\u8bef\uff01");
        }
        String clientBeanName = DataDistributeClientFactory.getOrDefault(this.clientConfigToSpringName, this.clientProvider, CANAL_CLIENT_BEAN_NAME);
        return (DataDistributeClient)this.applicationContext.getBean(clientBeanName);
    }

    public DataDistributeClient getClient(DataDistributeProviderEnum clientProviderName) {
        String clientBeanName = DataDistributeClientFactory.getOrDefault(this.clientConfigToSpringName, clientProviderName, null);
        return (DataDistributeClient)this.applicationContext.getBean(clientBeanName);
    }

    private static <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }
}

