/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datadistribute;

import com.dtyunxi.huieryun.datadistribute.constant.DataDistributeConsumerEnum;
import com.dtyunxi.huieryun.datadistribute.event.DataDistributeEvent;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

public abstract class DataEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DataEventHandler.class);
    protected ApplicationContext context;
    private IProducer mqProducer;
    private IMessageProcessor<DataDistributeEvent> process;
    @Value(value="${huieryun.datadistribute.mqtopic:}")
    private String mqTopic;
    @Value(value="${huieryun.datadistribute.consumer:localCall}")
    private String consumer;
    @Value(value="${huieryun.datadistribute.simulation.sleepTime:0}")
    private Long sleepTime;

    protected MessageResponse sendDataDistributeEvents(List<DataDistributeEvent> events) {
        for (DataDistributeEvent event : events) {
            MessageResponse response = this.sendDataDistributeEvent(event);
            if (!response.equals(MessageResponse.ERROR)) continue;
            return response;
        }
        return MessageResponse.SUCCESS;
    }

    protected MessageResponse sendDataDistributeEvent(DataDistributeEvent event) {
        long startTime = System.currentTimeMillis();
        switch (DataDistributeConsumerEnum.getByName(this.consumer)) {
            case MQ: {
                if (StringUtils.isBlank((CharSequence)this.mqTopic)) {
                    throw new IllegalArgumentException("MQ\u4e3b\u9898\u4e3a\u7a7a\uff01");
                }
                return this.getMqProducer().sendMessage(this.mqTopic, (Object)event);
            }
            case LOCAL_CALL: {
                IMessageProcessor<DataDistributeEvent> process = this.getProcess();
                if (null == process) {
                    throw new IllegalArgumentException("\u6d88\u606f\u5904\u7406\u7c7b\u5c1a\u672a\u521d\u59cb\u5316\uff01");
                }
                return process.process((Object)event);
            }
            case LOG: {
                logger.info("event={}", (Object)event);
                if (this.sleepTime <= 0L) break;
                this.simulateWorkElapsedTime();
            }
        }
        long useTime = System.currentTimeMillis() - startTime;
        logger.info("sendDataDistributeEvent,useTime={}ms", (Object)useTime);
        return MessageResponse.SUCCESS;
    }

    private void simulateWorkElapsedTime() {
        logger.info("simulation waiting,sleepTime={}", (Object)this.sleepTime);
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() <= l + this.sleepTime * 1000L) {
        }
    }

    private final IProducer getMqProducer() {
        if (null == this.mqProducer) {
            this.mqProducer = (IProducer)this.context.getBean(IProducer.class);
        }
        return this.mqProducer;
    }

    private final IMessageProcessor<DataDistributeEvent> getProcess() {
        if (null == this.process) {
            this.process = (IMessageProcessor)this.context.getBean("dataCollectMessageProcessor", IMessageProcessor.class);
        }
        return this.process;
    }

    protected abstract void setContext(ApplicationContext var1);
}

