/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datadistribute.constant;

public enum DataDistributeProviderEnum {
    CANAL("canal"),
    DTS("dts"),
    DRS("drs"),
    LOGSHIPPER("logShipper"),
    DTS_KAFKA("dtsKafka");

    private String name;

    private DataDistributeProviderEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DataDistributeProviderEnum getDataDistributeProvider() {
        String dataDistributeProvider = System.getProperty("huieryun.datadistribute.provider");
        for (DataDistributeProviderEnum provider : DataDistributeProviderEnum.values()) {
            if (!provider.name.equalsIgnoreCase(dataDistributeProvider)) continue;
            return provider;
        }
        return null;
    }

    public static boolean isCanal() {
        DataDistributeProviderEnum provider = DataDistributeProviderEnum.getDataDistributeProvider();
        return null != provider && provider.equals((Object)CANAL);
    }

    public static boolean isDts() {
        DataDistributeProviderEnum provider = DataDistributeProviderEnum.getDataDistributeProvider();
        return null != provider && provider.equals((Object)DTS);
    }

    public static boolean isLogShipper() {
        DataDistributeProviderEnum provider = DataDistributeProviderEnum.getDataDistributeProvider();
        return null != provider && provider.equals((Object)LOGSHIPPER);
    }
}

