/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datadistribute.listener;

import com.dtyunxi.huieryun.datadistribute.DataDistributeClient;
import com.dtyunxi.huieryun.datadistribute.DataDistributeClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.context.event.EventListener;

public final class DataDistributeClientStarter {
    private static final Logger logger = LoggerFactory.getLogger(DataDistributeClientStarter.class);
    @Autowired
    private DataDistributeClientFactory dataDistributeClientFactory;
    private static boolean startFlag = false;

    public DataDistributeClientStarter() {
    }

    public DataDistributeClientStarter(DataDistributeClientFactory dataDistributeClientFactory) {
        this.dataDistributeClientFactory = dataDistributeClientFactory;
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onApplicationStared() {
        logger.info("DataDistributeClientManager begin start");
        if (startFlag) {
            return;
        }
        startFlag = true;
        DataDistributeClient dataDistributeClient = this.dataDistributeClientFactory.getClient();
        dataDistributeClient.start();
        logger.info("DataDistributeClientManager on application started, start dataDistributeClient");
    }

    @EventListener(value={ContextClosedEvent.class, ContextStoppedEvent.class})
    public void onApplicationStoped() {
        logger.info("DataDistributeClientManager begin stop");
        DataDistributeClient dataDistributeClient = this.dataDistributeClientFactory.getClient();
        dataDistributeClient.stop();
        logger.info("DataDistributeClientManager on application Stoped");
    }
}

