/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datadistribute.impl;

import com.alibaba.otter.canal.client.AliyunMQCanalConnector;
import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalConnectors;
import com.alibaba.otter.canal.client.kafka.KafkaOffsetCanalConnector;
import com.alibaba.otter.canal.client.rocketmq.RocketMQCanalConnector;
import com.dtyunxi.huieryun.datadistribute.impl.CanalClientType;
import com.dtyunxi.vo.BaseVo;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.lang3.StringUtils;

public class CanalConfig
extends BaseVo {
    private static final long serialVersionUID = -1777721047422022031L;
    private String connectUrl;
    private String destination;
    private String connectType;
    private String tableFilterRegex;
    private String groupId;
    private int batchSize = 5120;
    private boolean flatMessage;
    private String accessKey;
    private String secretKey;
    private Integer partition;
    private boolean clound = false;
    private int consumeThreadNums = Runtime.getRuntime().availableProcessors();

    public String getConnectUrl() {
        return this.connectUrl;
    }

    public void setConnectUrl(String connectUrl) {
        this.connectUrl = connectUrl;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getConnectType() {
        return this.connectType;
    }

    public void setConnectType(String connectType) {
        this.connectType = connectType;
    }

    public String getTableFilterRegex() {
        return this.tableFilterRegex;
    }

    public void setTableFilterRegex(String tableFilterRegex) {
        this.tableFilterRegex = tableFilterRegex;
    }

    public final String getGroupId() {
        return this.groupId;
    }

    public final void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public final boolean isFlatMessage() {
        return this.flatMessage;
    }

    public final void setFlatMessage(boolean flatMessage) {
        this.flatMessage = flatMessage;
    }

    public final String getAccessKey() {
        return this.accessKey;
    }

    public final void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public final String getSecretKey() {
        return this.secretKey;
    }

    public final void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public final Integer getPartition() {
        return this.partition;
    }

    public final void setPartition(Integer partition) {
        this.partition = partition;
    }

    public CanalClientType getCanalClientType() {
        return CanalClientType.getByName(this.connectType);
    }

    public boolean isClound() {
        return this.clound;
    }

    public void setClound(boolean clound) {
        this.clound = clound;
    }

    public int getConsumeThreadNums() {
        return this.consumeThreadNums;
    }

    public void setConsumeThreadNums(int consumeThreadNums) {
        this.consumeThreadNums = consumeThreadNums;
    }

    public CanalConnector createConnectorByType() {
        CanalClientType canalClientType = this.getCanalClientType();
        if (null == canalClientType) {
            throw new RuntimeException("can't find the connect type type connect type is " + this.connectType);
        }
        switch (canalClientType) {
            case SIMPLE: {
                String[] hostAndPort = this.connectUrl.split(":");
                return CanalConnectors.newSingleConnector((SocketAddress)new InetSocketAddress(hostAndPort[0], (int)Integer.valueOf(hostAndPort[1])), (String)this.destination, (String)"", (String)"");
            }
            case CLUSTER: {
                return CanalConnectors.newClusterConnector((String)this.connectUrl, (String)this.destination, (String)"", (String)"");
            }
            case ROCKETMQ: {
                if (this.batchSize >= 1024) {
                    this.batchSize = 1024;
                }
                if (StringUtils.isNotBlank((CharSequence)this.accessKey) && StringUtils.isNotBlank((CharSequence)this.secretKey)) {
                    return new RocketMQCanalConnector(this.connectUrl, this.destination, this.groupId, this.accessKey, this.secretKey, Integer.valueOf(this.batchSize), this.flatMessage, this.clound);
                }
                return new RocketMQCanalConnector(this.connectUrl, this.destination, this.groupId, Integer.valueOf(this.batchSize), this.flatMessage);
            }
            case KAFKA: {
                return new KafkaOffsetCanalConnector(this.connectUrl, this.destination, this.partition, this.groupId, this.flatMessage);
            }
            case ALIYUNMQ: {
                return new AliyunMQCanalConnector(this.connectUrl, this.destination, this.groupId, this.accessKey, this.secretKey, this.batchSize, this.consumeThreadNums, this.flatMessage);
            }
        }
        throw new RuntimeException("can't find the connect type type connect type is " + this.connectType);
    }
}

