/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common;

import com.alibaba.dts.recordgenerator.ClusterSwitchListener;
import java.io.Closeable;
import java.io.File;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class Util {
    public static void swallowErrorClose(Closeable target) {
        try {
            if (null != target) {
                target.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleepMS(long value) {
        try {
            Thread.sleep(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void mergeSourceKafkaProperties(Properties originProperties, Properties mergeToProperties) {
        originProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = (String)k;
            if (key.startsWith("kafka.")) {
                String toPutKey = key.substring(6);
                mergeToProperties.setProperty(toPutKey, (String)v);
            }
        }));
        mergeToProperties.setProperty("sasl.jaas.config", Util.buildJaasConfig(originProperties.getProperty("sid"), originProperties.getProperty("user"), originProperties.getProperty("password")));
        mergeToProperties.setProperty("sasl.mechanism", "PLAIN");
        mergeToProperties.setProperty("security.protocol", "SASL_PLAINTEXT");
        mergeToProperties.setProperty("bootstrap.servers", originProperties.getProperty("broker"));
        mergeToProperties.setProperty("group.id", originProperties.getProperty("group"));
        mergeToProperties.setProperty("enable.auto.commit", "false");
        mergeToProperties.setProperty("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        mergeToProperties.setProperty("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        mergeToProperties.setProperty("interceptor.classes", ClusterSwitchListener.class.getName());
    }

    public static void require(boolean predict, String errMessage) {
        if (!predict) {
            throw new RuntimeException(errMessage);
        }
    }

    public static String buildJaasConfig(String sid, String user, String password) {
        String jaasTemplate = "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s-%s\" password=\"%s\";";
        return String.format(jaasTemplate, user, sid, password);
    }

    public static boolean checkFileExists(String fileName) {
        File metaFile = new File(fileName);
        return metaFile.exists();
    }

    public static void deleteFile(String fileName) {
        File maybeAbsolutePath = new File(fileName);
        if (!maybeAbsolutePath.exists()) {
            return;
        }
        File metaFile = null;
        if (maybeAbsolutePath.isAbsolute()) {
            metaFile = maybeAbsolutePath;
        } else {
            File currentPath = new File(".");
            metaFile = new File(currentPath.getAbsolutePath() + File.separator + fileName);
        }
        boolean deleted = metaFile.delete();
        if (!deleted) {
            throw new RuntimeException(metaFile.getAbsolutePath() + " should be cleaned anyway");
        }
    }

    private static void setIfAbsent(Properties properties, String key, String valueSetIfAbsent) {
        if (StringUtils.isEmpty((CharSequence)properties.getProperty(key))) {
            properties.setProperty(key, valueSetIfAbsent);
        }
    }

    public static String[] uncompressionObjectName(String compressionName) {
        if (null == compressionName || compressionName.isEmpty()) {
            return null;
        }
        String[] names = compressionName.split("\\.");
        int length = names.length;
        for (int i = 0; i < length; ++i) {
            names[i] = Util.unescapeName(names[i]);
        }
        return names;
    }

    private static String unescapeName(String name) {
        if (null == name || name.indexOf("\\u002E") < 0) {
            return name;
        }
        StringBuilder builder = new StringBuilder();
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('\\' == c && i < length - 6 && 'u' == name.charAt(i + 1) && '0' == name.charAt(i + 2) && '0' == name.charAt(i + 3) && '2' == name.charAt(i + 4) && 'E' == name.charAt(i + 5)) {
                builder.append(".");
                i += 5;
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static void sleepMs(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

