/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.formats.avro;

import com.alibaba.dts.formats.avro.Operation;
import com.alibaba.dts.formats.avro.Source;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class Record
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -5842551457902705544L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Record\",\"namespace\":\"com.alibaba.dts.formats.avro\",\"fields\":[{\"name\":\"version\",\"type\":\"int\",\"doc\":\"version infomation\"},{\"name\":\"id\",\"type\":\"long\",\"doc\":\"unique id of this record in the whole stream\"},{\"name\":\"sourceTimestamp\",\"type\":\"long\",\"doc\":\"record log timestamp\"},{\"name\":\"sourcePosition\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"record source location information\"},{\"name\":\"safeSourcePosition\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"safe record source location information, use to recovery.\",\"default\":\"\"},{\"name\":\"sourceTxid\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"record transation id\",\"default\":\"\"},{\"name\":\"source\",\"type\":{\"type\":\"record\",\"name\":\"Source\",\"fields\":[{\"name\":\"sourceType\",\"type\":{\"type\":\"enum\",\"name\":\"SourceType\",\"symbols\":[\"MySQL\",\"Oracle\",\"SQLServer\",\"PostgreSQL\",\"MongoDB\",\"Redis\",\"DB2\",\"PPAS\",\"DRDS\",\"HBASE\",\"HDFS\",\"FILE\",\"OTHER\"]}},{\"name\":\"version\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"source datasource version information\"}]},\"doc\":\"source dataource\"},{\"name\":\"operation\",\"type\":{\"type\":\"enum\",\"name\":\"Operation\",\"symbols\":[\"INSERT\",\"UPDATE\",\"DELETE\",\"DDL\",\"BEGIN\",\"COMMIT\",\"ROLLBACK\",\"ABORT\",\"HEARTBEAT\",\"CHECKPOINT\",\"COMMAND\",\"FILL\",\"FINISH\",\"CONTROL\",\"RDB\",\"NOOP\",\"INIT\"]},\"namespace\":\"com.alibaba.dts.formats.avro\"},{\"name\":\"objectName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"processTimestamps\",\"type\":[\"null\",{\"type\":\"array\",\"items\":\"long\"}],\"doc\":\"time when this record is processed along the stream dataflow\",\"default\":null},{\"name\":\"tags\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"},\"doc\":\"tags to identify properties of this record\",\"default\":{}},{\"name\":\"fields\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"},{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"Field\",\"fields\":[{\"name\":\"name\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"dataTypeNumber\",\"type\":\"int\"}]}}],\"default\":null},{\"name\":\"beforeImages\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"},{\"type\":\"array\",\"items\":[\"null\",{\"type\":\"record\",\"name\":\"Integer\",\"fields\":[{\"name\":\"precision\",\"type\":\"int\"},{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},{\"type\":\"record\",\"name\":\"Character\",\"fields\":[{\"name\":\"charset\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"value\",\"type\":\"bytes\"}]},{\"type\":\"record\",\"name\":\"Decimal\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"precision\",\"type\":\"int\"},{\"name\":\"scale\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"Float\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"},{\"name\":\"precision\",\"type\":\"int\"},{\"name\":\"scale\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"Timestamp\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"millis\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"DateTime\",\"fields\":[{\"name\":\"year\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"month\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"day\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"hour\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"minute\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"second\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"millis\",\"type\":[\"null\",\"int\"],\"default\":null}]},{\"type\":\"record\",\"name\":\"TimestampWithTimeZone\",\"fields\":[{\"name\":\"value\",\"type\":\"DateTime\"},{\"name\":\"timezone\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},{\"type\":\"record\",\"name\":\"BinaryGeometry\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"value\",\"type\":\"bytes\"}]},{\"type\":\"record\",\"name\":\"TextGeometry\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},{\"type\":\"record\",\"name\":\"BinaryObject\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"value\",\"type\":\"bytes\"}]},{\"type\":\"record\",\"name\":\"TextObject\",\"fields\":[{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},{\"type\":\"enum\",\"name\":\"EmptyObject\",\"symbols\":[\"NULL\",\"NONE\"]}]}],\"default\":null},{\"name\":\"afterImages\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"},{\"type\":\"array\",\"items\":[\"null\",\"Integer\",\"Character\",\"Decimal\",\"Float\",\"Timestamp\",\"DateTime\",\"TimestampWithTimeZone\",\"BinaryGeometry\",\"TextGeometry\",\"BinaryObject\",\"TextObject\",\"EmptyObject\"]}],\"default\":null},{\"name\":\"bornTimestamp\",\"type\":\"long\",\"doc\":\"the timestamp in unit of millisecond that record is born in source\",\"default\":0}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<Record> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<Record> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public int version;
    @Deprecated
    public long id;
    @Deprecated
    public long sourceTimestamp;
    @Deprecated
    public String sourcePosition;
    @Deprecated
    public String safeSourcePosition;
    @Deprecated
    public String sourceTxid;
    @Deprecated
    public Source source;
    @Deprecated
    public Operation operation;
    @Deprecated
    public String objectName;
    @Deprecated
    public List<Long> processTimestamps;
    @Deprecated
    public Map<String, String> tags;
    @Deprecated
    public Object fields;
    @Deprecated
    public Object beforeImages;
    @Deprecated
    public Object afterImages;
    @Deprecated
    public long bornTimestamp;
    private static final DatumWriter<Record> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<Record> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<Record> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<Record> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static Record fromByteBuffer(ByteBuffer b) throws IOException {
        return (Record)((Object)DECODER.decode(b));
    }

    public Record() {
    }

    public Record(Integer version, Long id, Long sourceTimestamp, String sourcePosition, String safeSourcePosition, String sourceTxid, Source source, Operation operation, String objectName, List<Long> processTimestamps, Map<String, String> tags, Object fields, Object beforeImages, Object afterImages, Long bornTimestamp) {
        this.version = version;
        this.id = id;
        this.sourceTimestamp = sourceTimestamp;
        this.sourcePosition = sourcePosition;
        this.safeSourcePosition = safeSourcePosition;
        this.sourceTxid = sourceTxid;
        this.source = source;
        this.operation = operation;
        this.objectName = objectName;
        this.processTimestamps = processTimestamps;
        this.tags = tags;
        this.fields = fields;
        this.beforeImages = beforeImages;
        this.afterImages = afterImages;
        this.bornTimestamp = bornTimestamp;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.version;
            }
            case 1: {
                return this.id;
            }
            case 2: {
                return this.sourceTimestamp;
            }
            case 3: {
                return this.sourcePosition;
            }
            case 4: {
                return this.safeSourcePosition;
            }
            case 5: {
                return this.sourceTxid;
            }
            case 6: {
                return this.source;
            }
            case 7: {
                return this.operation;
            }
            case 8: {
                return this.objectName;
            }
            case 9: {
                return this.processTimestamps;
            }
            case 10: {
                return this.tags;
            }
            case 11: {
                return this.fields;
            }
            case 12: {
                return this.beforeImages;
            }
            case 13: {
                return this.afterImages;
            }
            case 14: {
                return this.bornTimestamp;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.version = (Integer)value$;
                break;
            }
            case 1: {
                this.id = (Long)value$;
                break;
            }
            case 2: {
                this.sourceTimestamp = (Long)value$;
                break;
            }
            case 3: {
                this.sourcePosition = (String)value$;
                break;
            }
            case 4: {
                this.safeSourcePosition = (String)value$;
                break;
            }
            case 5: {
                this.sourceTxid = (String)value$;
                break;
            }
            case 6: {
                this.source = (Source)((Object)value$);
                break;
            }
            case 7: {
                this.operation = (Operation)((Object)value$);
                break;
            }
            case 8: {
                this.objectName = (String)value$;
                break;
            }
            case 9: {
                this.processTimestamps = (List)value$;
                break;
            }
            case 10: {
                this.tags = (Map)value$;
                break;
            }
            case 11: {
                this.fields = value$;
                break;
            }
            case 12: {
                this.beforeImages = value$;
                break;
            }
            case 13: {
                this.afterImages = value$;
                break;
            }
            case 14: {
                this.bornTimestamp = (Long)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long value) {
        this.id = value;
    }

    public Long getSourceTimestamp() {
        return this.sourceTimestamp;
    }

    public void setSourceTimestamp(Long value) {
        this.sourceTimestamp = value;
    }

    public String getSourcePosition() {
        return this.sourcePosition;
    }

    public void setSourcePosition(String value) {
        this.sourcePosition = value;
    }

    public String getSafeSourcePosition() {
        return this.safeSourcePosition;
    }

    public void setSafeSourcePosition(String value) {
        this.safeSourcePosition = value;
    }

    public String getSourceTxid() {
        return this.sourceTxid;
    }

    public void setSourceTxid(String value) {
        this.sourceTxid = value;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source value) {
        this.source = value;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation value) {
        this.operation = value;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String value) {
        this.objectName = value;
    }

    public List<Long> getProcessTimestamps() {
        return this.processTimestamps;
    }

    public void setProcessTimestamps(List<Long> value) {
        this.processTimestamps = value;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> value) {
        this.tags = value;
    }

    public Object getFields() {
        return this.fields;
    }

    public void setFields(Object value) {
        this.fields = value;
    }

    public Object getBeforeImages() {
        return this.beforeImages;
    }

    public void setBeforeImages(Object value) {
        this.beforeImages = value;
    }

    public Object getAfterImages() {
        return this.afterImages;
    }

    public void setAfterImages(Object value) {
        this.afterImages = value;
    }

    public Long getBornTimestamp() {
        return this.bornTimestamp;
    }

    public void setBornTimestamp(Long value) {
        this.bornTimestamp = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Record other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Record>
    implements RecordBuilder<Record> {
        private int version;
        private long id;
        private long sourceTimestamp;
        private String sourcePosition;
        private String safeSourcePosition;
        private String sourceTxid;
        private Source source;
        private Source.Builder sourceBuilder;
        private Operation operation;
        private String objectName;
        private List<Long> processTimestamps;
        private Map<String, String> tags;
        private Object fields;
        private Object beforeImages;
        private Object afterImages;
        private long bornTimestamp;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.version);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.id)) {
                this.id = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.id);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.sourceTimestamp)) {
                this.sourceTimestamp = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.sourceTimestamp);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sourcePosition)) {
                this.sourcePosition = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sourcePosition);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.safeSourcePosition)) {
                this.safeSourcePosition = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.safeSourcePosition);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.sourceTxid)) {
                this.sourceTxid = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.sourceTxid);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.source))) {
                this.source = (Source)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.source));
                this.fieldSetFlags()[6] = true;
            }
            if (other.hasSourceBuilder()) {
                this.sourceBuilder = Source.newBuilder(other.getSourceBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.operation))) {
                this.operation = (Operation)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.operation));
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.objectName)) {
                this.objectName = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.objectName);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], other.processTimestamps)) {
                this.processTimestamps = (List)this.data().deepCopy(this.fields()[9].schema(), other.processTimestamps);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], other.tags)) {
                this.tags = (Map)this.data().deepCopy(this.fields()[10].schema(), other.tags);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.fields)) {
                this.fields = this.data().deepCopy(this.fields()[11].schema(), other.fields);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.beforeImages)) {
                this.beforeImages = this.data().deepCopy(this.fields()[12].schema(), other.beforeImages);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.afterImages)) {
                this.afterImages = this.data().deepCopy(this.fields()[13].schema(), other.afterImages);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.bornTimestamp)) {
                this.bornTimestamp = (Long)this.data().deepCopy(this.fields()[14].schema(), (Object)other.bornTimestamp);
                this.fieldSetFlags()[14] = true;
            }
        }

        private Builder(Record other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.version);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.id)) {
                this.id = (Long)this.data().deepCopy(this.fields()[1].schema(), (Object)other.id);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.sourceTimestamp)) {
                this.sourceTimestamp = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.sourceTimestamp);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.sourcePosition)) {
                this.sourcePosition = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.sourcePosition);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.safeSourcePosition)) {
                this.safeSourcePosition = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.safeSourcePosition);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.sourceTxid)) {
                this.sourceTxid = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.sourceTxid);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)((Object)other.source))) {
                this.source = (Source)((Object)this.data().deepCopy(this.fields()[6].schema(), (Object)other.source));
                this.fieldSetFlags()[6] = true;
            }
            this.sourceBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)((Object)other.operation))) {
                this.operation = (Operation)((Object)this.data().deepCopy(this.fields()[7].schema(), (Object)other.operation));
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.objectName)) {
                this.objectName = (String)this.data().deepCopy(this.fields()[8].schema(), (Object)other.objectName);
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], other.processTimestamps)) {
                this.processTimestamps = (List)this.data().deepCopy(this.fields()[9].schema(), other.processTimestamps);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], other.tags)) {
                this.tags = (Map)this.data().deepCopy(this.fields()[10].schema(), other.tags);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.fields)) {
                this.fields = this.data().deepCopy(this.fields()[11].schema(), other.fields);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.beforeImages)) {
                this.beforeImages = this.data().deepCopy(this.fields()[12].schema(), other.beforeImages);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.afterImages)) {
                this.afterImages = this.data().deepCopy(this.fields()[13].schema(), other.afterImages);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.bornTimestamp)) {
                this.bornTimestamp = (Long)this.data().deepCopy(this.fields()[14].schema(), (Object)other.bornTimestamp);
                this.fieldSetFlags()[14] = true;
            }
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(int value) {
            this.validate(this.fields()[0], value);
            this.version = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearVersion() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getId() {
            return this.id;
        }

        public Builder setId(long value) {
            this.validate(this.fields()[1], value);
            this.id = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearId() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getSourceTimestamp() {
            return this.sourceTimestamp;
        }

        public Builder setSourceTimestamp(long value) {
            this.validate(this.fields()[2], value);
            this.sourceTimestamp = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasSourceTimestamp() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearSourceTimestamp() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getSourcePosition() {
            return this.sourcePosition;
        }

        public Builder setSourcePosition(String value) {
            this.validate(this.fields()[3], value);
            this.sourcePosition = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasSourcePosition() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearSourcePosition() {
            this.sourcePosition = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getSafeSourcePosition() {
            return this.safeSourcePosition;
        }

        public Builder setSafeSourcePosition(String value) {
            this.validate(this.fields()[4], value);
            this.safeSourcePosition = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasSafeSourcePosition() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearSafeSourcePosition() {
            this.safeSourcePosition = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getSourceTxid() {
            return this.sourceTxid;
        }

        public Builder setSourceTxid(String value) {
            this.validate(this.fields()[5], value);
            this.sourceTxid = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasSourceTxid() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearSourceTxid() {
            this.sourceTxid = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Source getSource() {
            return this.source;
        }

        public Builder setSource(Source value) {
            this.validate(this.fields()[6], (Object)value);
            this.sourceBuilder = null;
            this.source = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasSource() {
            return this.fieldSetFlags()[6];
        }

        public Source.Builder getSourceBuilder() {
            if (this.sourceBuilder == null) {
                if (this.hasSource()) {
                    this.setSourceBuilder(Source.newBuilder(this.source));
                } else {
                    this.setSourceBuilder(Source.newBuilder());
                }
            }
            return this.sourceBuilder;
        }

        public Builder setSourceBuilder(Source.Builder value) {
            this.clearSource();
            this.sourceBuilder = value;
            return this;
        }

        public boolean hasSourceBuilder() {
            return this.sourceBuilder != null;
        }

        public Builder clearSource() {
            this.source = null;
            this.sourceBuilder = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public Builder setOperation(Operation value) {
            this.validate(this.fields()[7], (Object)value);
            this.operation = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasOperation() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearOperation() {
            this.operation = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public Builder setObjectName(String value) {
            this.validate(this.fields()[8], value);
            this.objectName = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasObjectName() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearObjectName() {
            this.objectName = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public List<Long> getProcessTimestamps() {
            return this.processTimestamps;
        }

        public Builder setProcessTimestamps(List<Long> value) {
            this.validate(this.fields()[9], value);
            this.processTimestamps = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasProcessTimestamps() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearProcessTimestamps() {
            this.processTimestamps = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public Builder setTags(Map<String, String> value) {
            this.validate(this.fields()[10], value);
            this.tags = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasTags() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearTags() {
            this.tags = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public Object getFields() {
            return this.fields;
        }

        public Builder setFields(Object value) {
            this.validate(this.fields()[11], value);
            this.fields = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasFields() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearFields() {
            this.fields = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public Object getBeforeImages() {
            return this.beforeImages;
        }

        public Builder setBeforeImages(Object value) {
            this.validate(this.fields()[12], value);
            this.beforeImages = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasBeforeImages() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearBeforeImages() {
            this.beforeImages = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public Object getAfterImages() {
            return this.afterImages;
        }

        public Builder setAfterImages(Object value) {
            this.validate(this.fields()[13], value);
            this.afterImages = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasAfterImages() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearAfterImages() {
            this.afterImages = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public Long getBornTimestamp() {
            return this.bornTimestamp;
        }

        public Builder setBornTimestamp(long value) {
            this.validate(this.fields()[14], value);
            this.bornTimestamp = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasBornTimestamp() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearBornTimestamp() {
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public Record build() {
            try {
                Record record = new Record();
                record.version = this.fieldSetFlags()[0] ? this.version : (Integer)this.defaultValue(this.fields()[0]);
                record.id = this.fieldSetFlags()[1] ? this.id : (Long)this.defaultValue(this.fields()[1]);
                record.sourceTimestamp = this.fieldSetFlags()[2] ? this.sourceTimestamp : (Long)this.defaultValue(this.fields()[2]);
                record.sourcePosition = this.fieldSetFlags()[3] ? this.sourcePosition : (String)this.defaultValue(this.fields()[3]);
                record.safeSourcePosition = this.fieldSetFlags()[4] ? this.safeSourcePosition : (String)this.defaultValue(this.fields()[4]);
                String string = record.sourceTxid = this.fieldSetFlags()[5] ? this.sourceTxid : (String)this.defaultValue(this.fields()[5]);
                record.source = this.sourceBuilder != null ? this.sourceBuilder.build() : (this.fieldSetFlags()[6] ? this.source : (Source)((Object)this.defaultValue(this.fields()[6])));
                record.operation = this.fieldSetFlags()[7] ? this.operation : (Operation)((Object)this.defaultValue(this.fields()[7]));
                record.objectName = this.fieldSetFlags()[8] ? this.objectName : (String)this.defaultValue(this.fields()[8]);
                record.processTimestamps = this.fieldSetFlags()[9] ? this.processTimestamps : (List)this.defaultValue(this.fields()[9]);
                record.tags = this.fieldSetFlags()[10] ? this.tags : (Map)this.defaultValue(this.fields()[10]);
                record.fields = this.fieldSetFlags()[11] ? this.fields : this.defaultValue(this.fields()[11]);
                record.beforeImages = this.fieldSetFlags()[12] ? this.beforeImages : this.defaultValue(this.fields()[12]);
                record.afterImages = this.fieldSetFlags()[13] ? this.afterImages : this.defaultValue(this.fields()[13]);
                record.bornTimestamp = this.fieldSetFlags()[14] ? this.bornTimestamp : (Long)this.defaultValue(this.fields()[14]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

