/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.recordgenerator;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSwitchListener
implements ClusterResourceListener,
ConsumerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ClusterSwitchListener.class);
    private ClusterResource originClusterResource = null;

    public ConsumerRecords onConsume(ConsumerRecords records) {
        return records;
    }

    public void close() {
    }

    public void onCommit(Map offsets) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate(ClusterResource clusterResource) {
        ClusterSwitchListener clusterSwitchListener = this;
        synchronized (clusterSwitchListener) {
            if (null == this.originClusterResource) {
                logger.info("Cluster updated to " + clusterResource.clusterId());
                this.originClusterResource = clusterResource;
            } else if (clusterResource.clusterId().equals(this.originClusterResource.clusterId())) {
                logger.info("Cluster not changed on update:" + clusterResource.clusterId());
            } else {
                throw new ClusterSwitchException("Cluster changed from " + this.originClusterResource.clusterId() + " to " + clusterResource.clusterId() + ", consumer require restart");
            }
        }
    }

    public void configure(Map<String, ?> configs) {
    }

    public static class ClusterSwitchException
    extends KafkaException {
        public ClusterSwitchException(String message, Throwable cause) {
            super(message, cause);
        }

        public ClusterSwitchException(String message) {
            super(message);
        }

        public ClusterSwitchException(Throwable cause) {
            super(cause);
        }

        public ClusterSwitchException() {
        }
    }
}

