/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.recordprocessor;

import com.alibaba.dts.recordprocessor.mysql.JDKEncodingMapper;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;

public class FieldValue {
    private String encoding;
    private byte[] bytes;

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getValue() {
        return this.bytes;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setValue(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toString() {
        if (null == this.getValue()) {
            return "null [binary]";
        }
        if (this.encoding == null) {
            return super.toString();
        }
        try {
            if (StringUtils.equals((CharSequence)"utf8mb4", (CharSequence)this.encoding)) {
                return new String(this.getValue(), "utf8");
            }
            return new String(this.getValue(), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            String realEncoding = JDKEncodingMapper.getJDKEncoding(this.encoding);
            if (null == realEncoding) {
                throw new RuntimeException("Unsupported encoding: " + this.encoding);
            }
            try {
                return new String(this.getValue(), realEncoding);
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeException("Unsupported encoding: origin " + this.encoding + ", mapped " + realEncoding);
            }
        }
    }
}

