/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.recordprocessor.mysql;

import com.alibaba.dts.formats.avro.BinaryGeometry;
import com.alibaba.dts.formats.avro.BinaryObject;
import com.alibaba.dts.formats.avro.Character;
import com.alibaba.dts.formats.avro.DateTime;
import com.alibaba.dts.formats.avro.Decimal;
import com.alibaba.dts.formats.avro.Field;
import com.alibaba.dts.formats.avro.Float;
import com.alibaba.dts.formats.avro.Integer;
import com.alibaba.dts.formats.avro.TextObject;
import com.alibaba.dts.formats.avro.Timestamp;
import com.alibaba.dts.recordprocessor.FieldConverter;
import com.alibaba.dts.recordprocessor.FieldValue;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class MysqlFieldConverter
implements FieldConverter {
    static DataAdapter[] DATA_ADAPTER = new DataAdapter[256];

    @Override
    public FieldValue convert(Field field, Object o) {
        return DATA_ADAPTER[field.getDataTypeNumber()].getFieldValue(o);
    }

    static byte[] getBytes(ByteBuffer origin) {
        byte[] ret = new byte[origin.remaining()];
        origin.get(ret);
        return ret;
    }

    static {
        MysqlFieldConverter.DATA_ADAPTER[0] = new DecimalStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[1] = new NumberStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[2] = new NumberStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[3] = new NumberStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[4] = new DoubleStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[5] = new DoubleStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[6] = new UTF8StringEncodeAdapter();
        MysqlFieldConverter.DATA_ADAPTER[7] = new TimestampStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[8] = new NumberStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[9] = new NumberStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[10] = new DateAdapter();
        MysqlFieldConverter.DATA_ADAPTER[11] = new TimeAdapter();
        MysqlFieldConverter.DATA_ADAPTER[12] = new DateTimeAdapter();
        MysqlFieldConverter.DATA_ADAPTER[13] = new YearAdapter();
        MysqlFieldConverter.DATA_ADAPTER[14] = new DateTimeAdapter();
        MysqlFieldConverter.DATA_ADAPTER[15] = new CharacterAdapter();
        MysqlFieldConverter.DATA_ADAPTER[16] = new NumberStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[255] = new GeometryAdapter();
        MysqlFieldConverter.DATA_ADAPTER[254] = new CharacterAdapter();
        MysqlFieldConverter.DATA_ADAPTER[253] = new CharacterAdapter();
        MysqlFieldConverter.DATA_ADAPTER[252] = new BinaryAdapter();
        MysqlFieldConverter.DATA_ADAPTER[251] = new BinaryAdapter();
        MysqlFieldConverter.DATA_ADAPTER[250] = new BinaryAdapter();
        MysqlFieldConverter.DATA_ADAPTER[249] = new BinaryAdapter();
        MysqlFieldConverter.DATA_ADAPTER[246] = new DecimalStringAdapter();
        MysqlFieldConverter.DATA_ADAPTER[248] = new TextObjectAdapter();
        MysqlFieldConverter.DATA_ADAPTER[247] = new TextObjectAdapter();
        MysqlFieldConverter.DATA_ADAPTER[245] = new TextObjectAdapter();
    }

    static class TextObjectAdapter
    implements DataAdapter {
        TextObjectAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                TextObject textObject = (TextObject)((Object)data);
                byte[] bytes = textObject.getValue().getBytes(StandardCharsets.UTF_8);
                fieldValue.setValue(bytes);
            }
            fieldValue.setEncoding("UTF8");
            return fieldValue;
        }
    }

    static class BinaryAdapter
    implements DataAdapter {
        BinaryAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                BinaryObject binaryObject = (BinaryObject)((Object)data);
                fieldValue.setValue(MysqlFieldConverter.getBytes(binaryObject.getValue()));
            }
            return fieldValue;
        }
    }

    static class GeometryAdapter
    implements DataAdapter {
        GeometryAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                BinaryGeometry geometry = (BinaryGeometry)((Object)data);
                fieldValue.setValue(MysqlFieldConverter.getBytes(geometry.getValue()));
            }
            return fieldValue;
        }
    }

    static class CharacterAdapter
    implements DataAdapter {
        CharacterAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                Character character = (Character)((Object)data);
                fieldValue.setValue(MysqlFieldConverter.getBytes(character.getValue()));
                fieldValue.setEncoding(character.getCharset());
            } else {
                fieldValue.setEncoding("ASCII");
            }
            return fieldValue;
        }
    }

    static class YearAdapter
    implements DataAdapter {
        YearAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                DateTime dateTime = (DateTime)((Object)data);
                fieldValue.setValue(java.lang.Integer.toString(dateTime.getYear()).getBytes(StandardCharsets.US_ASCII));
            }
            fieldValue.setEncoding("ASCII");
            return fieldValue;
        }
    }

    static class DateTimeAdapter
    extends AbstractDateTimeAdapter {
        DateTimeAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                DateTime dateTime = (DateTime)((Object)data);
                byte[] time = null;
                time = null == dateTime.getMillis() || 0 == dateTime.getMillis() ? new byte[19] : new byte[26];
                this.encodeDate(dateTime, time, 0);
                time[10] = 32;
                this.encodeTime(dateTime, time, 11);
                this.encodeTimeMillis(dateTime, time, 19);
                fieldValue.setValue(time);
            }
            fieldValue.setEncoding("ASCII");
            return fieldValue;
        }
    }

    static class TimeAdapter
    extends AbstractDateTimeAdapter {
        TimeAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                DateTime dateTime = (DateTime)((Object)data);
                int head = 0;
                if (dateTime.getHour() <= -100) {
                    head = 2;
                } else if (dateTime.getHour() >= 100 || dateTime.getHour() < 0 || dateTime.getMinute() < 0 || dateTime.getSecond() < 0 || null != dateTime.getMillis() && dateTime.getMillis() < 0) {
                    head = 1;
                }
                byte[] time = null == dateTime.getMillis() || 0 == dateTime.getMillis() ? new byte[8 + head] : new byte[15 + head];
                int index = 0;
                if (head > 0 && dateTime.getHour() <= 0) {
                    dateTime.setHour(-dateTime.getHour().intValue());
                    dateTime.setMinute(-dateTime.getMinute().intValue());
                    dateTime.setSecond(-dateTime.getSecond().intValue());
                    if (null != dateTime.getMillis()) {
                        dateTime.setMillis(-dateTime.getMillis().intValue());
                    }
                    time[index++] = 45;
                }
                if (dateTime.getHour() >= 100) {
                    time[index++] = (byte)(48 + dateTime.getHour() / 100);
                    dateTime.setHour(dateTime.getHour() % 100);
                }
                this.encodeTime(dateTime, time, index);
                this.encodeTimeMillis(dateTime, time, index + 8);
                fieldValue.setValue(time);
            }
            fieldValue.setEncoding("ASCII");
            return fieldValue;
        }
    }

    static class DateAdapter
    extends AbstractDateTimeAdapter {
        DateAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                DateTime dateTime = (DateTime)((Object)data);
                byte[] date = new byte[10];
                this.encodeDate(dateTime, date, 0);
                fieldValue.setValue(date);
            }
            fieldValue.setEncoding("ASCII");
            return fieldValue;
        }
    }

    static abstract class AbstractDateTimeAdapter
    implements DataAdapter {
        AbstractDateTimeAdapter() {
        }

        void encodeDate(DateTime dateTime, byte[] out, int position) {
            if (null != dateTime && null != out) {
                out[position] = (byte)(48 + dateTime.getYear() / 1000);
                out[position + 1] = (byte)(48 + dateTime.getYear() % 1000 / 100);
                out[position + 2] = (byte)(48 + dateTime.getYear() % 100 / 10);
                out[position + 3] = (byte)(48 + dateTime.getYear() % 10);
                out[position + 4] = 45;
                out[position + 5] = (byte)(48 + dateTime.getMonth() / 10);
                out[position + 6] = (byte)(48 + dateTime.getMonth() % 10);
                out[position + 7] = 45;
                out[position + 8] = (byte)(48 + dateTime.getDay() / 10);
                out[position + 9] = (byte)(48 + dateTime.getDay() % 10);
            }
        }

        void encodeTime(DateTime dateTime, byte[] out, int position) {
            if (null != dateTime && null != out) {
                out[position + 0] = (byte)(48 + dateTime.getHour() / 10);
                out[position + 1] = (byte)(48 + dateTime.getHour() % 10);
                out[position + 2] = 58;
                out[position + 3] = (byte)(48 + dateTime.getMinute() / 10);
                out[position + 4] = (byte)(48 + dateTime.getMinute() % 10);
                out[position + 5] = 58;
                out[position + 6] = (byte)(48 + dateTime.getSecond() / 10);
                out[position + 7] = (byte)(48 + dateTime.getSecond() % 10);
            }
        }

        void encodeTimeMillis(DateTime dateTime, byte[] out, int position) {
            if (null != dateTime.getMillis() && 0 != dateTime.getMillis()) {
                int mills = dateTime.getMillis();
                out[position] = 46;
                out[position + 1] = (byte)(48 + mills / 100000);
                out[position + 2] = (byte)(48 + (mills %= 100000) / 10000);
                out[position + 3] = (byte)(48 + (mills %= 10000) / 1000);
                out[position + 4] = (byte)(48 + (mills %= 1000) / 100);
                out[position + 5] = (byte)(48 + (mills %= 100) / 10);
                out[position + 6] = (byte)(48 + mills % 10);
            }
        }
    }

    static class TimestampStringAdapter
    implements DataAdapter {
        static String[] MILLIS_PREFIX = new String[]{"", "0", "00", "000", "0000", "00000", "000000"};

        TimestampStringAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                StringBuilder timestampBuilder = new StringBuilder(64);
                Timestamp timestamp = (Timestamp)((Object)data);
                timestampBuilder.append(timestamp.getTimestamp());
                if (null != timestamp.getMillis()) {
                    timestampBuilder.append('.');
                    String millis = java.lang.Integer.toString(timestamp.getMillis());
                    timestampBuilder.append(MILLIS_PREFIX[6 - millis.length()]).append(millis);
                }
                fieldValue.setValue(timestampBuilder.toString().getBytes(StandardCharsets.US_ASCII));
            }
            fieldValue.setEncoding("ASCII");
            return fieldValue;
        }
    }

    static class DoubleStringAdapter
    implements DataAdapter {
        DoubleStringAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                Float aFloat = (Float)((Object)data);
                fieldValue.setValue(Double.toString(aFloat.getValue()).getBytes(StandardCharsets.US_ASCII));
            }
            fieldValue.setEncoding("ASCII");
            return fieldValue;
        }
    }

    static class DecimalStringAdapter
    implements DataAdapter {
        DecimalStringAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                Decimal decimal = (Decimal)((Object)data);
                fieldValue.setValue(decimal.getValue().getBytes(StandardCharsets.US_ASCII));
            }
            fieldValue.setEncoding("ASCII");
            return fieldValue;
        }
    }

    static class NumberStringAdapter
    implements DataAdapter {
        NumberStringAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                Integer integer = (Integer)((Object)data);
                fieldValue.setValue(integer.getValue().getBytes(StandardCharsets.US_ASCII));
            }
            fieldValue.setEncoding("ASCII");
            return fieldValue;
        }
    }

    static class UTF8StringEncodeAdapter
    implements DataAdapter {
        UTF8StringEncodeAdapter() {
        }

        @Override
        public FieldValue getFieldValue(Object data) {
            FieldValue fieldValue = new FieldValue();
            if (null != data) {
                byte[] bytes = ((String)data).getBytes(StandardCharsets.UTF_8);
                fieldValue.setValue(bytes);
            }
            fieldValue.setEncoding("UTF8");
            return fieldValue;
        }
    }

    static interface DataAdapter {
        public FieldValue getFieldValue(Object var1);
    }
}

