/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datadistribute.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class DescribeConsumerGroup
implements Serializable {
    @JsonProperty(value="ConsumerChannels")
    private ConsumerChannel consumerChannel;

    public String getCheckpoint() {
        if (this.consumerChannel == null) {
            return null;
        }
        if (this.consumerChannel.getChannels() == null || this.consumerChannel.getChannels().length == 0) {
            return null;
        }
        DescribeConsumerChannel channel = this.consumerChannel.getChannels()[0];
        if (StringUtils.isBlank((CharSequence)channel.getCheckpoint())) {
            return null;
        }
        String consumptionCheckpointStr = channel.getCheckpoint().replaceAll("Z", "");
        Long consumptionCheckpointTime = LocalDateTime.parse(consumptionCheckpointStr, DateTimeFormatter.ISO_LOCAL_DATE_TIME).toEpochSecond(ZoneOffset.of("+8"));
        return String.valueOf(consumptionCheckpointTime);
    }

    public ConsumerChannel getConsumerChannel() {
        return this.consumerChannel;
    }

    public void setConsumerChannel(ConsumerChannel consumerChannel) {
        this.consumerChannel = consumerChannel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DescribeConsumerGroup)) {
            return false;
        }
        DescribeConsumerGroup other = (DescribeConsumerGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConsumerChannel this$consumerChannel = this.getConsumerChannel();
        ConsumerChannel other$consumerChannel = other.getConsumerChannel();
        return !(this$consumerChannel == null ? other$consumerChannel != null : !((Object)this$consumerChannel).equals(other$consumerChannel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DescribeConsumerGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConsumerChannel $consumerChannel = this.getConsumerChannel();
        result = result * 59 + ($consumerChannel == null ? 43 : ((Object)$consumerChannel).hashCode());
        return result;
    }

    public String toString() {
        return "DescribeConsumerGroup(consumerChannel=" + this.getConsumerChannel() + ")";
    }

    public static class DescribeConsumerChannel
    implements Serializable {
        @JsonProperty(value="ConsumerGroupID")
        private String groupId;
        @JsonProperty(value="ConsumerGroupUserName")
        private String groupName;
        @JsonProperty(value="ConsumerGroupName")
        private String userName;
        @JsonProperty(value="MessageDelay")
        private String messageDelay;
        @JsonProperty(value="UnconsumedData")
        private String unconsumedData;
        @JsonProperty(value="ConsumptionCheckpoint")
        private String checkpoint;

        public String getGroupId() {
            return this.groupId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getMessageDelay() {
            return this.messageDelay;
        }

        public String getUnconsumedData() {
            return this.unconsumedData;
        }

        public String getCheckpoint() {
            return this.checkpoint;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setMessageDelay(String messageDelay) {
            this.messageDelay = messageDelay;
        }

        public void setUnconsumedData(String unconsumedData) {
            this.unconsumedData = unconsumedData;
        }

        public void setCheckpoint(String checkpoint) {
            this.checkpoint = checkpoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DescribeConsumerChannel)) {
                return false;
            }
            DescribeConsumerChannel other = (DescribeConsumerChannel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$groupName = this.getGroupName();
            String other$groupName = other.getGroupName();
            if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$messageDelay = this.getMessageDelay();
            String other$messageDelay = other.getMessageDelay();
            if (this$messageDelay == null ? other$messageDelay != null : !this$messageDelay.equals(other$messageDelay)) {
                return false;
            }
            String this$unconsumedData = this.getUnconsumedData();
            String other$unconsumedData = other.getUnconsumedData();
            if (this$unconsumedData == null ? other$unconsumedData != null : !this$unconsumedData.equals(other$unconsumedData)) {
                return false;
            }
            String this$checkpoint = this.getCheckpoint();
            String other$checkpoint = other.getCheckpoint();
            return !(this$checkpoint == null ? other$checkpoint != null : !this$checkpoint.equals(other$checkpoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DescribeConsumerChannel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $groupName = this.getGroupName();
            result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $messageDelay = this.getMessageDelay();
            result = result * 59 + ($messageDelay == null ? 43 : $messageDelay.hashCode());
            String $unconsumedData = this.getUnconsumedData();
            result = result * 59 + ($unconsumedData == null ? 43 : $unconsumedData.hashCode());
            String $checkpoint = this.getCheckpoint();
            result = result * 59 + ($checkpoint == null ? 43 : $checkpoint.hashCode());
            return result;
        }

        public String toString() {
            return "DescribeConsumerGroup.DescribeConsumerChannel(groupId=" + this.getGroupId() + ", groupName=" + this.getGroupName() + ", userName=" + this.getUserName() + ", messageDelay=" + this.getMessageDelay() + ", unconsumedData=" + this.getUnconsumedData() + ", checkpoint=" + this.getCheckpoint() + ")";
        }
    }

    public static class ConsumerChannel
    implements Serializable {
        @JsonProperty(value="DescribeConsumerChannel")
        private DescribeConsumerChannel[] channels;

        public DescribeConsumerChannel[] getChannels() {
            return this.channels;
        }

        public void setChannels(DescribeConsumerChannel[] channels) {
            this.channels = channels;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsumerChannel)) {
                return false;
            }
            ConsumerChannel other = (ConsumerChannel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.deepEquals(this.getChannels(), other.getChannels());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConsumerChannel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getChannels());
            return result;
        }

        public String toString() {
            return "DescribeConsumerGroup.ConsumerChannel(channels=" + Arrays.deepToString(this.getChannels()) + ")";
        }
    }
}

