/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datadistribute.impl;

import com.alibaba.dts.common.FieldEntryHolder;
import com.alibaba.dts.common.Util;
import com.alibaba.dts.formats.avro.Field;
import com.alibaba.dts.formats.avro.Operation;
import com.alibaba.dts.formats.avro.Record;
import com.alibaba.dts.recordprocessor.FieldConverter;
import com.alibaba.dts.recordprocessor.FieldValue;
import com.alibaba.dts.recordprocessor.mysql.MysqlToDataTypeNumberEnum;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.huieryun.datadistribute.DataEventHandler;
import com.dtyunxi.huieryun.datadistribute.event.Column;
import com.dtyunxi.huieryun.datadistribute.event.DataDistributeEvent;
import com.dtyunxi.huieryun.datadistribute.event.DeleteEvent;
import com.dtyunxi.huieryun.datadistribute.event.InsertEvent;
import com.dtyunxi.huieryun.datadistribute.event.UpdateEvent;
import com.dtyunxi.huieryun.datadistribute.impl.DtsKafkaConfig;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class DtsKafkaEventHandler
extends DataEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(DtsKafkaEventHandler.class);
    private static final FieldConverter FIELD_CONVERTER = FieldConverter.getConverter("mysql", null);
    private static final Pattern SYMBOL_PATTERN = Pattern.compile("(?<=\\[\").*?(?=\"\\])");

    public MessageResponse messageHandler(Record record, DtsKafkaConfig config) {
        if (!(Operation.INSERT.equals((Object)record.getOperation()) || Operation.UPDATE.equals((Object)record.getOperation()) || Operation.DELETE.equals((Object)record.getOperation()))) {
            return MessageResponse.SUCCESS;
        }
        String dbName = null;
        String tableName = null;
        String[] dbPair = Util.uncompressionObjectName(record.getObjectName());
        if (null != dbPair) {
            if (dbPair.length == 2) {
                dbName = dbPair[0];
                tableName = dbPair[1];
            } else if (dbPair.length == 3) {
                dbName = dbPair[0];
                tableName = dbPair[2];
            } else if (dbPair.length == 1) {
                dbName = dbPair[0];
                tableName = "";
            } else {
                logger.info("invalid db and table name pair for record [" + (Object)((Object)record) + "]");
                return MessageResponse.SUCCESS;
            }
        }
        long executeTime = record.getSourceTimestamp();
        String primary = this.getPrimaryKey(record);
        DataDistributeEvent event = null;
        List fields = (List)record.getFields();
        FieldEntryHolder[] fieldArray = this.getFieldEntryHolder(record);
        ArrayList columnList = Lists.newArrayList();
        this.appendFields(fields, fieldArray[0], fieldArray[1], columnList, primary, config.getEncoding());
        switch (record.getOperation()) {
            case INSERT: {
                event = this.handleInsert(dbName, tableName, executeTime, columnList);
                break;
            }
            case UPDATE: {
                event = this.handleUpdate(dbName, tableName, executeTime, columnList);
                break;
            }
            case DELETE: {
                event = this.handleDelete(dbName, tableName, executeTime, columnList);
                break;
            }
            case DDL: {
                if (!logger.isDebugEnabled()) break;
                logger.debug("recevie the DDL flag event, but not handler in this version,record={}", (Object)record.toString());
                break;
            }
            case BEGIN: 
            case COMMIT: 
            case ROLLBACK: {
                logger.debug("recevie the transaction flag event, but not handler in this version");
                break;
            }
        }
        if (event != null) {
            logger.debug("dispach event [{}]", event);
            return this.sendDataDistributeEvent(event);
        }
        return MessageResponse.SUCCESS;
    }

    private String getPrimaryKey(Record record) {
        Map map;
        List<String> list;
        String pkInfo;
        String primary = "";
        Map<String, String> tagMap = record.getTags();
        if (MapUtils.isNotEmpty(tagMap) && StringUtils.isNotEmpty((CharSequence)(pkInfo = tagMap.get("pk_uk_info"))) && CollectionUtils.isNotEmpty(list = DtsKafkaEventHandler.getSymbolList(primary = (String)(map = (Map)JSONObject.parseObject((String)pkInfo, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0])).get("PRIMARY")))) {
            primary = list.get(0);
        }
        return primary;
    }

    private DataDistributeEvent handleInsert(String schemaName, String tableName, long executeTime, List<Column> columnList) {
        InsertEvent insertEvent = new InsertEvent(schemaName, tableName, executeTime);
        for (Column column : columnList) {
            if (StringUtils.isEmpty((CharSequence)column.getValue())) continue;
            insertEvent.addColumn(column);
        }
        return insertEvent;
    }

    private DataDistributeEvent handleUpdate(String schemaName, String tableName, long executeTime, List<Column> columnList) {
        UpdateEvent updateEvent = new UpdateEvent(schemaName, tableName, executeTime);
        for (Column column : columnList) {
            if ("dr".equals(column.getName()) && !column.getValue().equals(column.getOldValue())) {
                switch (column.getValue()) {
                    case "1": {
                        updateEvent.setDr(1);
                        break;
                    }
                    case "2": {
                        updateEvent.setDr(2);
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)column.getValue()) && StringUtils.isEmpty((CharSequence)column.getOldValue())) continue;
            updateEvent.addColumn(column);
        }
        return updateEvent;
    }

    private DataDistributeEvent handleDelete(String schemaName, String tableName, long executeTime, List<Column> columnList) {
        DeleteEvent deleteEvent = new DeleteEvent(schemaName, tableName, executeTime);
        for (Column column : columnList) {
            if (StringUtils.isEmpty((CharSequence)column.getOldValue())) continue;
            deleteEvent.addColumn(column);
        }
        return deleteEvent;
    }

    private FieldEntryHolder[] getFieldEntryHolder(Record record) {
        FieldEntryHolder[] fieldArray = new FieldEntryHolder[]{new FieldEntryHolder((List)record.getBeforeImages()), new FieldEntryHolder((List)record.getAfterImages())};
        return fieldArray;
    }

    private void appendFields(List<Field> fields, FieldEntryHolder before, FieldEntryHolder after, List<Column> columnList, String primary, String encoding) {
        if (null != fields) {
            Iterator<Field> fieldIterator = fields.iterator();
            while (fieldIterator.hasNext() && before.hasNext() && after.hasNext()) {
                Field field = fieldIterator.next();
                Object toPrintBefore = before.take();
                Object toPrintAfter = after.take();
                this.appendField(field, toPrintBefore, toPrintAfter, columnList, primary, encoding);
            }
        }
    }

    private void appendField(Field field, Object beforeImage, Object afterImage, List<Column> columnList, String primary, String encoding) {
        String filedName = field.getName();
        String filedType = MysqlToDataTypeNumberEnum.getDescByType(field.getDataTypeNumber());
        String oldValue = "";
        String value = "";
        boolean changed = true;
        if (beforeImage != null) {
            oldValue = this.getFiledValue(field, beforeImage, encoding);
        }
        if (afterImage != null) {
            value = this.getFiledValue(field, afterImage, encoding);
        }
        if (oldValue.equals(value)) {
            changed = false;
        }
        boolean primaryKey = false;
        if (primary.equals(filedName)) {
            primaryKey = true;
        }
        Column column = new Column(filedName, filedType, value, changed);
        column.setOldValue(oldValue);
        column.setPrimaryKey(primaryKey);
        columnList.add(column);
    }

    private String getFiledValue(Field field, Object beforeImage, String encoding) {
        FieldValue fieldValue = FIELD_CONVERTER.convert(field, beforeImage);
        if (MysqlToDataTypeNumberEnum.BLOB.getType().equals(field.getDataTypeNumber()) || MysqlToDataTypeNumberEnum.GEOMETRY.getType().equals(field.getDataTypeNumber())) {
            if ("utf8".equalsIgnoreCase(encoding) || "utf8mb4".equalsIgnoreCase(encoding)) {
                encoding = "utf8mb4";
            }
            fieldValue.setEncoding(encoding);
        }
        String oldValue = fieldValue.toString();
        return oldValue;
    }

    private static List<String> getMatcherList(String str, Pattern pattern) {
        ArrayList list = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                list.add(matcher.group());
            }
        }
        return list;
    }

    public static List<String> getSymbolList(String str) {
        return DtsKafkaEventHandler.getMatcherList(str, SYMBOL_PATTERN);
    }

    @Autowired
    protected void setContext(ApplicationContext context) {
        this.context = context;
    }
}

