/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datadistribute.event;

import com.dtyunxi.huieryun.datadistribute.event.Column;
import com.dtyunxi.huieryun.datadistribute.event.DataDistributeEvent;
import com.dtyunxi.huieryun.datadistribute.event.EventType;
import java.util.ArrayList;
import java.util.List;

public abstract class DbChangeDataDistributeEvent
extends DataDistributeEvent {
    private static final long serialVersionUID = 1L;
    private String schemaName;
    private String tableName;
    private int dr;
    private long executeTime;
    protected List<Column> columns;

    public DbChangeDataDistributeEvent(EventType eventType, String schemaName, String tableName, long executeTime) {
        super(eventType);
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.executeTime = executeTime;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getExecuteTime() {
        return this.executeTime;
    }

    public int getDr() {
        return this.dr;
    }

    public void setDr(int dr) {
        switch (dr) {
            case 1: {
                this.eventType = EventType.DELOGIC;
                break;
            }
            case 2: {
                this.eventType = EventType.DELETE;
            }
        }
        this.dr = dr;
    }

    public void addColumn(Column column) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(column);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public final void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public String toString() {
        return "DataDistributeEvent [eventType=" + (Object)((Object)this.eventType) + ", schemaName=" + this.schemaName + ", tableName=" + this.tableName + ", executeTime=" + this.executeTime + "]";
    }

    protected String values() {
        return "columns= " + this.columns.toString();
    }
}

