/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.datasubscribe.provider.dts;

import com.aliyun.drc.client.message.DataMessage;
import com.dtyunxi.huieryun.datasubscribe.event.Column;
import com.dtyunxi.huieryun.datasubscribe.event.DataSubScribeEvent;
import com.dtyunxi.huieryun.datasubscribe.event.DeleteEvent;
import com.dtyunxi.huieryun.datasubscribe.event.InsertEvent;
import com.dtyunxi.huieryun.datasubscribe.event.UpdateEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DtsEventHandler {
    private static Logger logger = LoggerFactory.getLogger(DtsEventHandler.class);

    public DataSubScribeEvent onEvent(DataMessage.Record record) {
        List fields = record.getFieldList();
        String schemaName = null;
        try {
            schemaName = record.getLogicalDbname();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (schemaName == null) {
            schemaName = record.getDbname();
        }
        String tableName = null;
        try {
            tableName = record.getLogicalTablename();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (tableName == null) {
            tableName = record.getTablename();
        }
        long executeTime = Long.parseLong(record.getTimestamp());
        try {
            StringBuilder fieldLog = new StringBuilder();
            for (DataMessage.Record.Field field : fields) {
                String filedType = field.getType().toString();
                String filedName = field.getFieldname();
                Object filedValue = this.getFieldValue(field);
                fieldLog.append(filedType).append(" ").append(filedName).append(" ").append(filedValue).append(" | ");
            }
            logger.info("indexbuilder receive from dts: schemaName {} tableName {} excuteTime {} recordType {} fields {}", new Object[]{schemaName, tableName, executeTime, record.getOpt(), fieldLog.toString()});
        }
        catch (Exception e) {
            logger.error("indexbuilder \u6253\u70b9\u65e5\u5fd7\u62a5\u9519", (Throwable)e);
        }
        DataSubScribeEvent event = null;
        switch (record.getOpt()) {
            case INSERT: {
                logger.info("recevie the insert event,schemaName:{},tableName:{}", (Object)schemaName, (Object)tableName);
                event = this.handleInsert(fields, schemaName, tableName, executeTime);
                break;
            }
            case UPDATE: {
                logger.info("recevie the update event,schemaName:{},tableName:{}", (Object)schemaName, (Object)tableName);
                event = this.handleUpdate(fields, schemaName, tableName, executeTime);
                break;
            }
            case DELETE: {
                logger.info("recevie the delete event,schemaName:{},tableName:{}", (Object)schemaName, (Object)tableName);
                event = this.handleDelete(fields, schemaName, tableName, executeTime);
                break;
            }
            case DDL: {
                logger.info("recevie the DDL flag event, but not handler in this version");
                break;
            }
            case BEGIN: {
                logger.info("recevie the begin event, but not handler in this version");
            }
            case COMMIT: {
                logger.info("recevie the commit flag event, but not handler in this version");
            }
            case ROLLBACK: {
                logger.info("recevie the transaction flag event, but not handler in this version");
                break;
            }
        }
        if (event == null) {
            logger.info("ignore this event,schemaName:{},tableName:{}", (Object)schemaName, (Object)tableName);
        } else {
            logger.info("dispach this event,schemaName:{},tableName:{}", (Object)schemaName, (Object)tableName);
        }
        logger.info("dispach event [{}]", event);
        return event;
    }

    private DataSubScribeEvent handleInsert(List<DataMessage.Record.Field> fields, String schemaName, String tableName, long executeTime) {
        InsertEvent insertEvent = new InsertEvent(schemaName, tableName, executeTime);
        for (DataMessage.Record.Field field : fields) {
            insertEvent.addColumn(this.changeEventColumn(field));
        }
        return insertEvent;
    }

    private DataSubScribeEvent handleDelete(List<DataMessage.Record.Field> fields, String schemaName, String tableName, long executeTime) {
        DeleteEvent deleteEvent = new DeleteEvent(schemaName, tableName, executeTime);
        for (DataMessage.Record.Field field : fields) {
            deleteEvent.addColumn(this.changeEventColumn(field));
        }
        return deleteEvent;
    }

    private Column changeEventColumn(DataMessage.Record.Field field) {
        String filedType = field.getType().toString();
        String filedName = field.getFieldname();
        Object filedValue = this.getFieldValue(field);
        return new Column(filedName, filedType, filedValue, field.isChangeValue());
    }

    private Object getFieldValue(DataMessage.Record.Field field) {
        String strfiledValue = null;
        try {
            String string = strfiledValue = null != field.getValue() ? field.getValue().toString("utf8") : null;
            if (StringUtils.isEmpty((Object)strfiledValue)) {
                return null;
            }
            Object filedValue = null;
            switch (field.getType()) {
                case INT8: 
                case INT16: 
                case INT24: 
                case INT32: 
                case INT64: {
                    filedValue = Long.valueOf(strfiledValue);
                    break;
                }
                case DECIMAL: 
                case FLOAT: 
                case DOUBLE: {
                    filedValue = Double.valueOf(strfiledValue);
                    break;
                }
                default: {
                    filedValue = strfiledValue;
                }
            }
            return filedValue;
        }
        catch (Exception e) {
            String msg = String.format("DTS\u7c7b\u578b\u8f6c\u6362\u51fa\u9519\uff0cfiledType {} , strFiledValue {}", field.getType().toString(), strfiledValue);
            logger.error(msg, (Throwable)e);
            return strfiledValue;
        }
    }

    private DataSubScribeEvent handleUpdate(List<DataMessage.Record.Field> fields, String schemaName, String tableName, long executeTime) {
        UpdateEvent updateEvent = new UpdateEvent(schemaName, tableName, executeTime);
        for (int i = 0; i < fields.size(); i += 2) {
            DataMessage.Record.Field befoerField = fields.get(i);
            DataMessage.Record.Field afterField = fields.get(i + 1);
            Column column = this.changeEventColumn(afterField);
            column.setOldValue(this.getFieldValue(befoerField));
            updateEvent.addColumn(column);
        }
        return updateEvent;
    }
}

