/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.lang;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BusinessRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected static Map<String, String> mapMessage = new ConcurrentHashMap<String, String>();
    public static final String SYSTEM_INTERNAL_ERROR = "10001";
    public static final String PARAMETER_ERROR = "10002";
    public static final String RECORD_DUPLICATED = "11001";
    public static final String RECORD_NOTEXIST = "11002";
    public static final String APIGATEWAY_ERROR = "99999";
    protected String code = null;
    protected String rawMessage = null;

    public BusinessRuntimeException(String message) {
        this(SYSTEM_INTERNAL_ERROR, message);
    }

    public BusinessRuntimeException(String message, Throwable e) {
        this(SYSTEM_INTERNAL_ERROR, message, e);
    }

    public BusinessRuntimeException(String code, String message) {
        super("{\"code\":\"" + code + "\", \"message\":\"" + message + "\"}");
        this.code = code;
        this.rawMessage = message;
    }

    public BusinessRuntimeException(String code, String message, Throwable e) {
        super("{\"code\":\"" + code + "\", \"message\":\"" + message + "\"}", e);
        this.code = code;
        this.rawMessage = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    public String toRestResponseJson() {
        return JacksonUtil.toJson(new RestResponse(this.code, this.rawMessage));
    }

    public static String getMessage(int code) {
        return mapMessage.get(String.valueOf(code));
    }

    static {
        mapMessage.put(SYSTEM_INTERNAL_ERROR, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef");
        mapMessage.put(PARAMETER_ERROR, "\u4e1a\u52a1\u53c2\u6570\u5f02\u5e38");
        mapMessage.put(RECORD_DUPLICATED, "\u8bb0\u5f55\u91cd\u590d");
        mapMessage.put(RECORD_NOTEXIST, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
    }
}

