/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.identity.auth.api;

import com.dtyunxi.huieryun.identity.auth.api.CallerPermission;
import com.dtyunxi.rest.RestResponse;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AccessPermissionInterceptor
implements HandlerInterceptor,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(AccessPermissionInterceptor.class);
    private ApplicationContext context;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String DEFAULT_CONTENTYPE = "application/json;charset=UTF-8";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String apiKey = request.getHeader("apikey");
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            this.write(new RestResponse(10005, "api key\u6821\u9a8c\u9519\u8bef"), response);
            return false;
        }
        CallerPermission permission = null;
        try {
            permission = (CallerPermission)this.context.getBean(apiKey);
        }
        catch (Throwable e) {
            logger.debug(e.getMessage(), e);
        }
        if (null == permission) {
            logger.debug("\u672a\u627e\u5230apiKey\u4e3a:{}\u7684\u7b7e\u540d\u914d\u7f6e.\u8bbf\u95ee\u8bf7\u6c42\u88ab\u62d2\u7edd", (Object)apiKey);
            this.write(new RestResponse(10005, "api key\u6821\u9a8c\u9519\u8bef"), response);
            return false;
        }
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        this.fullQueryParams(request, params);
        String sign = (String)params.remove("sign");
        if (StringUtils.isEmpty((CharSequence)sign)) {
            logger.debug("\u672a\u53d1\u73b0\u7b7e\u540d\u53c2\u6570,\u8bf7\u6c42\u975e\u6cd5.");
            this.write(new RestResponse(10006, "\u7b7e\u540d\u9519\u8bef"), response);
            return false;
        }
        String localSign = permission.calculateSign(params, DEFAULT_CHARSET);
        if (!sign.equals(localSign)) {
            logger.debug("\u7b7e\u540d\u9519\u8bef,\u672c\u5730\u7b7e\u540d\u7ed3\u679c:{},\u8fdc\u7aef\u7b7e\u540d:{}", (Object)localSign, (Object)sign);
            this.write(new RestResponse(10006, "\u7b7e\u540d\u9519\u8bef"), response);
            return false;
        }
        String path = request.getRequestURI().replace(request.getContextPath(), "");
        logger.debug("\u8bf7\u6c42\u5730\u5740:{}", (Object)path);
        if (permission.doAuth(path, apiKey)) {
            return true;
        }
        this.write(new RestResponse(10007, "\u60a8\u6ca1\u6709\u8be5\u63a5\u53e3\u7684\u8bbf\u95ee\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7533\u8bf7"), response);
        return false;
    }

    private void write(RestResponse responseData, HttpServletResponse response) throws JsonProcessingException, IOException {
        response.setContentType(DEFAULT_CONTENTYPE);
        try (ServletOutputStream os = response.getOutputStream();){
            os.write(objectMapper.writeValueAsBytes((Object)responseData));
        }
    }

    private void fullQueryParams(HttpServletRequest request, Map<String, Object> params) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String key = (String)paramNames.nextElement();
            params.put(key, request.getParameter(key));
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

