/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.identity.auth.api;

import com.dtyunxi.app.AppEnv;
import com.dtyunxi.app.ServiceConstants;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.identity.auth.api.AuthTokenUtil;
import com.dtyunxi.huieryun.identity.auth.api.UriWhiteSet;
import com.dtyunxi.huieryun.identity.util.IdentityCommUtil;
import com.dtyunxi.huieryun.identity.vo.LoginVo;
import com.dtyunxi.huieryun.registry.api.IRegistryService;
import com.dtyunxi.util.MD5Util;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class AuthInterceptor
extends HandlerInterceptorAdapter
implements ServiceConstants {
    private static final Logger logger = LoggerFactory.getLogger(AuthInterceptor.class);
    private static String respResult = "{\"resultCode\":401,\"resultMsg\":\"no login\",\"loginStatus\":\"loginStatusValue\"}";
    private static String respResultKeyword = "{\"resultCode\":406,\"resultMsg\":\"Illegal keyword arguments\"}";
    private String loginStatus = "";
    @Autowired
    private AppEnv appEnv;
    @Autowired
    private UriWhiteSet uriWhiteSet;
    @Autowired
    private ICacheService cacheService;
    IRegistryService registryService;
    private static String[] sqlKeyword = new String[]{"exec ", "execute ", "insert ", "create ", "drop ", " table ", " from ", "grant ", "use ", "group_concat ", "column_name ", "information_schema.columns ", "table_schema ", "union ", " where ", "select ", "delete ", "update ", " order by ", " count( ", "chr ", "mid ", "alert ", "master ", "having ", "truncate ", "char ", "declare ", "or ", "like ", " '", "-- ", "' ", "(select ", "/*", "*/", "+ "};

    public AuthInterceptor() {
    }

    public AuthInterceptor(IRegistryService registryService) {
        this.registryService = registryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object handler) throws Exception {
        LoginVo loginVo;
        String authToken;
        String uri;
        boolean isContinue;
        block32: {
            block31: {
                String sign;
                String timestamp;
                block30: {
                    block29: {
                        isContinue = false;
                        String flag = httpRequest.getHeader("Flag");
                        this.loginStatus = "";
                        String terminalType = httpRequest.getHeader("yes.req.terminal.type");
                        if (StringUtils.isNotEmpty((CharSequence)terminalType)) {
                            ServiceContext.getContext().setAttachment("yes.req.terminal.type", terminalType);
                        } else {
                            ServiceContext.getContext().setAttachment("yes.req.terminal.type", null);
                        }
                        uri = httpRequest.getRequestURI().replace(httpRequest.getContextPath(), "");
                        if (!this.uriWhiteSet.contains(uri)) break block29;
                        isContinue = true;
                        ServiceContext.getContext().setAttachment("yes.req.userId", null);
                        ServiceContext.getContext().setAttachment("yes.req.openId", null);
                        logger.info("\u53ef\u76f4\u63a5\u8bbf\u95ee\u7684uri = {}", (Object)uri);
                        boolean bl = isContinue;
                        logger.info("isContinue\u503c\u4e3a {}", (Object)isContinue);
                        if (!isContinue) {
                            String status = String.valueOf(401);
                            httpResponse.setStatus(Integer.valueOf(status).intValue());
                            PrintWriter out = httpResponse.getWriter();
                            out.append(respResult.replaceAll("loginStatusValue", this.loginStatus));
                            out.close();
                        } else if (this.checkKeyword(httpRequest)) {
                            httpResponse.setStatus(406);
                            PrintWriter out = httpResponse.getWriter();
                            out.append(respResultKeyword);
                            out.close();
                            isContinue = false;
                        }
                        return bl;
                    }
                    authToken = AuthTokenUtil.getAuthToken(httpRequest);
                    timestamp = httpRequest.getHeader("Timestamp");
                    sign = httpRequest.getHeader("Sign");
                    logger.info("preHandle \u643a\u5e26 httpRequest getHeader timestamp={}  sign={} token={}", new Object[]{timestamp, sign, authToken});
                    if (!StringUtils.isEmpty((CharSequence)authToken)) break block30;
                    boolean bl = isContinue;
                    logger.info("isContinue\u503c\u4e3a {}", (Object)isContinue);
                    if (!isContinue) {
                        String status = String.valueOf(401);
                        httpResponse.setStatus(Integer.valueOf(status).intValue());
                        PrintWriter out = httpResponse.getWriter();
                        out.append(respResult.replaceAll("loginStatusValue", this.loginStatus));
                        out.close();
                    } else if (this.checkKeyword(httpRequest)) {
                        httpResponse.setStatus(406);
                        PrintWriter out = httpResponse.getWriter();
                        out.append(respResultKeyword);
                        out.close();
                        isContinue = false;
                    }
                    return bl;
                }
                boolean verifyBool = this.verifyTimestampSign(authToken, timestamp, sign);
                if (verifyBool) break block31;
                logger.error("===========\u7b7e\u540d\u9274\u6743\u9a8c\u8bc1\u672a\u901a\u8fc7\uff0c\u4e0d\u5141\u8bb8\u8bbf\u95ee\u8d44\u6e90============");
                boolean out = isContinue;
                logger.info("isContinue\u503c\u4e3a {}", (Object)isContinue);
                if (!isContinue) {
                    String status = String.valueOf(401);
                    httpResponse.setStatus(Integer.valueOf(status).intValue());
                    PrintWriter out2 = httpResponse.getWriter();
                    out2.append(respResult.replaceAll("loginStatusValue", this.loginStatus));
                    out2.close();
                } else if (this.checkKeyword(httpRequest)) {
                    httpResponse.setStatus(406);
                    PrintWriter out3 = httpResponse.getWriter();
                    out3.append(respResultKeyword);
                    out3.close();
                    isContinue = false;
                }
                return out;
            }
            loginVo = AuthTokenUtil.decodeToken(authToken);
            if (loginVo != null) break block32;
            boolean out3 = isContinue;
            logger.info("isContinue\u503c\u4e3a {}", (Object)isContinue);
            if (!isContinue) {
                String status = String.valueOf(401);
                httpResponse.setStatus(Integer.valueOf(status).intValue());
                PrintWriter out = httpResponse.getWriter();
                out.append(respResult.replaceAll("loginStatusValue", this.loginStatus));
                out.close();
            } else if (this.checkKeyword(httpRequest)) {
                httpResponse.setStatus(406);
                PrintWriter out = httpResponse.getWriter();
                out.append(respResultKeyword);
                out.close();
                isContinue = false;
            }
            return out3;
        }
        try {
            try {
                boolean checkTokenBool = this.checkToken(loginVo.getAuthKey(), authToken);
                if (checkTokenBool && (isContinue = this.isLogin(loginVo, uri))) {
                    this.extendCacheTime(loginVo.getTrench(), loginVo.getAuthKey(), authToken);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception e) {
            logger.error("error message", (Throwable)e);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            logger.info("isContinue\u503c\u4e3a {}", (Object)isContinue);
            if (!isContinue) {
                String status = String.valueOf(401);
                httpResponse.setStatus(Integer.valueOf(status).intValue());
                PrintWriter out = httpResponse.getWriter();
                out.append(respResult.replaceAll("loginStatusValue", this.loginStatus));
                out.close();
            } else if (this.checkKeyword(httpRequest)) {
                httpResponse.setStatus(406);
                PrintWriter out = httpResponse.getWriter();
                out.append(respResultKeyword);
                out.close();
                isContinue = false;
            }
        }
        return isContinue;
    }

    private boolean verifyTimestampSign(String authToken, String timestamp, String sign) {
        boolean bool = true;
        if (this.registryService == null) {
            return true;
        }
        String interfaceSecurity = this.registryService.get("huieryun.identity.interceptor.interface.security");
        if (StringUtils.isEmpty((CharSequence)interfaceSecurity)) {
            return bool;
        }
        if ("timestamp".equals(interfaceSecurity = interfaceSecurity.toLowerCase())) {
            bool = this.verifyTimestamp(timestamp);
        } else if ("sign".equals(interfaceSecurity)) {
            bool = this.verifySign(authToken, timestamp, sign);
        } else if ("timestampsign".equals(interfaceSecurity) && (bool = this.verifyTimestamp(timestamp))) {
            bool = this.verifySign(authToken, timestamp, sign);
        }
        return bool;
    }

    private boolean verifyTimestamp(String timestamp) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)timestamp)) {
                Long currentTimeMillis = System.currentTimeMillis();
                Long minute = (currentTimeMillis - Long.valueOf(timestamp)) / 60000L;
                if (minute > 0L && minute < 5L) {
                    return true;
                }
                logger.info("\u9a8c\u8bc1\u65f6\u95f4\u6233\u662f\u5426\u5408\u6cd5minute = {} ,0~5\u5206\u949f\u4ee5\u5185\u5c5e\u4e8e\u5408\u6cd5", (Object)minute);
            }
        }
        catch (Exception e) {
            logger.error("verifyTimestamp error : ", (Throwable)e);
        }
        return false;
    }

    private boolean verifySign(String authToken, String timestamp, String sign) {
        if (StringUtils.isNotEmpty((CharSequence)sign) && StringUtils.isNotEmpty((CharSequence)authToken) && StringUtils.isNotEmpty((CharSequence)timestamp)) {
            String signMd5 = MD5Util.getMD5Code((String)(authToken + timestamp));
            if (sign.equals(signMd5)) {
                return true;
            }
            logger.info("\u9a8c\u8bc1\u7b7e\u540d\u662f\u5426\u5408\u6cd5\uff0c\u540e\u53f0\u751f\u6210sign:{}", (Object)signMd5);
        }
        return false;
    }

    private void extendCacheTime(String trench, String key, String authToken) {
        this.cacheService.setCache("huieryun-identity", key, (Object)authToken, IdentityCommUtil.getCacheValidityTime(trench));
    }

    private boolean isLogin(LoginVo loginVo, String uri) {
        boolean bool = false;
        Long userId = loginVo.getUserId() != null ? loginVo.getUserId() : 0L;
        String openId = loginVo.getOpenId();
        if (userId != null && userId != 0L) {
            ServiceContext.getContext().setAppId(this.appEnv.getAppId());
            ServiceContext.getContext().setAppSecret(this.appEnv.getAppSecret());
            ServiceContext.getContext().setAttachment("yes.req.userId", userId.toString());
            ServiceContext.getContext().setAttachment("yes.req.userCode", loginVo.getUserCode());
            ServiceContext.getContext().setAttachment("yes.req.userType", loginVo.getUserType());
            ServiceContext.getContext().setAttachment("yes.req.trench", loginVo.getTrench());
            ServiceContext.getContext().setAttachment("yes.req.tenantId", loginVo.getTenantId() != null ? loginVo.getTenantId().toString() : "0");
            ServiceContext.getContext().setAttachment("yes.req.openId", "0".equals(openId) ? null : openId);
            ServiceContext.getContext().setAttachment("yes.req.applicationId", String.valueOf(loginVo.getApplicationId()));
            bool = true;
            return bool;
        }
        if (this.uriWhiteSet.containsWithOpenId(uri)) {
            ServiceContext.getContext().setAttachment("yes.req.userId", null);
            ServiceContext.getContext().setAttachment("yes.req.userCode", null);
            ServiceContext.getContext().setAttachment("yes.req.userType", loginVo.getUserType());
            ServiceContext.getContext().setAttachment("yes.req.tenantId", loginVo.getTenantId() != null ? loginVo.getTenantId().toString() : "0");
            ServiceContext.getContext().setAttachment("yes.req.openId", "0".equals(openId) ? null : openId);
            ServiceContext.getContext().setAttachment("yes.req.applicationId", String.valueOf(loginVo.getApplicationId()));
            bool = true;
        }
        return bool;
    }

    private boolean checkToken(String key, String authToken) {
        String authTokenCache = (String)this.cacheService.getCache("huieryun-identity", key, String.class);
        if (StringUtils.isEmpty((CharSequence)authTokenCache)) {
            this.loginStatus = "2";
            return false;
        }
        if (!authToken.equals(authTokenCache)) {
            this.loginStatus = "1";
            return false;
        }
        return true;
    }

    private boolean checkKeyword(HttpServletRequest httpRequest) {
        Map map = httpRequest.getParameterMap();
        Set set = map.entrySet();
        boolean checkBool = false;
        if (map != null) {
            for (Map.Entry entry : set) {
                if (!(entry.getValue() instanceof String[])) continue;
                String[] values = (String[])entry.getValue();
                for (int i = 0; i < values.length; ++i) {
                    if (!this.sqlValidate(values[i])) continue;
                    return true;
                }
            }
        }
        return checkBool;
    }

    private boolean sqlValidate(String param) {
        if (StringUtils.isEmpty((CharSequence)param)) {
            return false;
        }
        for (int i = 0; i < sqlKeyword.length; ++i) {
            if (param.toLowerCase().indexOf(sqlKeyword[i]) == -1) continue;
            logger.error("\u8bf7\u6c42\u88ab\u62e6\u622a======>\u53c2\u6570\u4e2d\u542b\u6709SQL\u5173\u952e\u5b57\uff1a{}", (Object)sqlKeyword[i]);
            return true;
        }
        return false;
    }
}

