/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;

public abstract class AbstractApiLogAspect {
    private static Logger logger = LoggerFactory.getLogger(AbstractApiLogAspect.class);
    protected static final String LEVEL_EMP = "empty";
    protected static final String LEVEL_ADJ = "adjust";
    protected static final String LEVEL_FULL = "full";
    protected static final int ADJ_LEN = 4096;
    protected int dtoNullValueLogLevel = 0;

    public abstract void apiLogAop();

    protected String getLogRespLevel() {
        return LEVEL_EMP;
    }

    public int getDtoNullValueLogLevel() {
        return this.dtoNullValueLogLevel;
    }

    protected int getAdjustLenth() {
        return 4096;
    }

    @Around(value="apiLogAop()")
    public Object aroundApi(ProceedingJoinPoint point) throws Throwable {
        return this.log(point);
    }

    protected Object log(ProceedingJoinPoint point) throws Throwable {
        Object response;
        block9: {
            DateTime startTime = new DateTime();
            DateTime endTime = null;
            Interval interval = null;
            response = null;
            boolean showNull4req = (this.getDtoNullValueLogLevel() & 1) == 1;
            boolean showNull4resp = (this.getDtoNullValueLogLevel() & 2) == 2;
            String jsonStrFromReq = this.reqToString(point.getArgs(), showNull4req);
            try {
                logger.info("Call API {}.{} Begin () Request => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq});
                response = point.proceed();
            }
            catch (Exception e) {
                endTime = new DateTime();
                interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
                logger.error("Call API {}.{} End () Request => {}, RT:{} ms, Error => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), e.getMessage()});
                logger.error("", (Throwable)e);
                throw e;
            }
            endTime = new DateTime();
            interval = new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
            if (response instanceof RestResponse) {
                try {
                    RestResponse restResponse = (RestResponse)response;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.respToString(restResponse)});
                    }
                    if (LEVEL_FULL.equals(this.getLogRespLevel())) {
                        logger.info("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.reqToString(response, showNull4resp)});
                        break block9;
                    }
                    if (LEVEL_ADJ.equals(this.getLogRespLevel())) {
                        logger.info("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.respToAdjustString(restResponse)});
                        break block9;
                    }
                    logger.info("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.respToString(restResponse)});
                }
                catch (Exception e) {
                    logger.error("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.reqToString(response)});
                }
            } else {
                logger.info("Call API {}.{} End () Request => {}, RT:{} ms, Response => {}", new Object[]{point.getSignature().getDeclaringTypeName(), point.getSignature().getName(), jsonStrFromReq, interval.toDurationMillis(), this.objToString(response, showNull4resp)});
            }
        }
        return response;
    }

    protected String reqToString(Object object, boolean showNull) {
        return this.objToString(object, showNull);
    }

    protected String objToString(Object object, boolean showNull) {
        try {
            if (showNull) {
                return JSON.toJSONString((Object)object, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]);
            }
            return JSON.toJSONString((Object)object);
        }
        catch (Exception e) {
            logger.error("JSON \u8f6c\u6362\u51fa\u9519\uff0c\u54cd\u5e94\u4fe1\u606f\u4e0d\u660e", (Throwable)e);
            return "JSON \u8f6c\u6362\u51fa\u9519\uff0c\u54cd\u5e94\u4fe1\u606f\u4e0d\u660e";
        }
    }

    protected String reqToString(Object object) {
        return this.reqToString(object, false);
    }

    protected String respToString(RestResponse<?> restResponse) {
        return "{\"reultCode\":" + restResponse.getResultCode() + ",\"resultMsg\":\"" + restResponse.getResultMsg() + "\"}";
    }

    protected String respToAdjustString(RestResponse<?> restResponse) {
        String data = JSON.toJSONString((Object)restResponse.getData());
        return "{\"reultCode\":" + restResponse.getResultCode() + ",\"resultMsg\":\"" + restResponse.getResultMsg() + "\", \"data\":\"" + data.substring(0, data.length() > this.getAdjustLenth() ? this.getAdjustLenth() : data.length()) + "\"}";
    }
}

