/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.log;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.LogConstants;
import com.dtyunxi.huieryun.log.LogSetting;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yes.rpc.AbstractMicroServiceContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class LoggerServletFilter
implements Filter,
LogConstants {
    private static final Logger logger = LoggerFactory.getLogger(LoggerServletFilter.class);

    @Deprecated
    public static void initLogger() {
        LogSetting.initLogger();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.beforeFilter(request);
        try {
            chain.doFilter(request, response);
        }
        catch (IOException | ServletException e) {
            logger.error("\u8fc7\u6ee4\u5f02\u5e38\uff01", e);
            throw e;
        }
        finally {
            this.afterFilter();
        }
    }

    void beforeFilter(ServletRequest request) {
        MDC.put((String)"yes.req.remoteHost", (String)request.getRemoteHost());
        MDC.put((String)"yes.req.remoteAddr", (String)request.getRemoteAddr());
        MDC.put((String)"yes.req.remotePort", (String)String.valueOf(request.getRemotePort()));
        MDC.put((String)"yes.req.localAddr", (String)request.getLocalAddr());
        MDC.put((String)"yes.req.localPort", (String)String.valueOf(request.getLocalPort()));
        String requestId = request.getParameter("reqId");
        String reqClientId = null;
        if (request instanceof HttpServletRequest) {
            String reqTerminalType;
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            MDC.put((String)"yes.req.requestURI", (String)httpServletRequest.getRequestURI());
            StringBuffer requestURL = httpServletRequest.getRequestURL();
            if (requestURL != null) {
                MDC.put((String)"yes.req.requestURL", (String)requestURL.toString());
            }
            MDC.put((String)"yes.req.method", (String)httpServletRequest.getMethod());
            MDC.put((String)"yes.req.queryString", (String)httpServletRequest.getQueryString());
            MDC.put((String)"yes.req.userAgent", (String)httpServletRequest.getHeader("User-Agent"));
            MDC.put((String)"yes.req.xForwardedFor", (String)httpServletRequest.getHeader("X-Forwarded-For"));
            if (requestId == null) {
                requestId = httpServletRequest.getHeader(AbstractMicroServiceContext.createContextKey((String)"yes.req.requestId"));
            }
            if (StringUtils.isNotBlank((CharSequence)(reqTerminalType = httpServletRequest.getHeader("yes.req.terminal.type")))) {
                MDC.put((String)"yes.req.terminal.type", (String)reqTerminalType);
                ServiceContext.getContext().setAttachment("yes.req.terminal.type", reqTerminalType);
            }
            reqClientId = httpServletRequest.getHeader("yes.req.clientId");
        }
        if (requestId == null) {
            requestId = RequestId.createReqId();
        }
        if (StringUtils.isNotBlank(reqClientId)) {
            MDC.put((String)"yes.req.clientId", reqClientId);
            ServiceContext.getContext().setAttachment("yes.req.clientId", reqClientId);
            String str = System.getProperty("dtyunxi.huieryun.log.mergeRequestIdAndReqClientId");
            if (StringUtils.isBlank((CharSequence)str) || Boolean.parseBoolean(str)) {
                requestId = reqClientId + "_" + requestId;
            }
        }
        MDC.put((String)"yes.req.requestId", (String)requestId);
        MDC.put((String)"yes.req.userId", (String)"anonymous");
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
    }

    void afterFilter() {
        MDC.remove((String)"yes.req.remoteHost");
        MDC.remove((String)"yes.req.remoteAddr");
        MDC.remove((String)"yes.req.remotePort");
        MDC.remove((String)"yes.req.localAddr");
        MDC.remove((String)"yes.req.localPort");
        MDC.remove((String)"yes.req.requestURI");
        MDC.remove((String)"yes.req.requestURL");
        MDC.remove((String)"yes.req.method");
        MDC.remove((String)"yes.req.queryString");
        MDC.remove((String)"yes.req.userAgent");
        MDC.remove((String)"yes.req.xForwardedFor");
        MDC.remove((String)"yes.req.requestId");
        MDC.remove((String)"yes.req.userId");
        MDC.remove((String)"yes.req.terminal.type");
        MDC.remove((String)"yes.req.clientId");
        ServiceContext.getContext().removeAttachment("yes.req.requestId");
        ServiceContext.getContext().removeAttachment("yes.req.terminal.type");
        ServiceContext.getContext().removeAttachment("yes.req.clientId");
    }

    public void destroy() {
    }
}

