/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.aliyun;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.api.AbstractConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.aliyun.util.AliyunConsumerHelper;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AliyunConsumer
extends AbstractConsumer {
    private static Logger logger = LoggerFactory.getLogger(AliyunConsumer.class);
    private static final AliyunConsumer single = new AliyunConsumer();
    private static final ConcurrentHashMap<String, Consumer> consumerMap = new ConcurrentHashMap();

    private AliyunConsumer() {
    }

    public static AliyunConsumer getInstance() {
        return single;
    }

    public <T> MessageResponse receiveMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        logger.info("receiveMessage,topicName:{},routingKey:{}", (Object)topicName, (Object)routingKey);
        return this.subscribe(topicName, routingKey, processor);
    }

    public <T> MessageResponse receiveMessage(String topic, String consumer, String routingKey, IMessageProcessor<T> processor) {
        return this.subscribe(topic, consumer, routingKey, processor);
    }

    public MessageResponse receiveMessage(String topic, String consumer, Map<String, IMessageProcessor> processorMap) {
        return this.subscribe(topic, consumer, processorMap);
    }

    public <T> MessageResponse subscribe(String topicName, String consumer, String routingKey, IMessageProcessor<T> processor) {
        logger.info("subscribeMessage,topicName:{},consumer:{},routingKey:{}", new Object[]{topicName, consumer, routingKey});
        try {
            this.toSubscribe(this.messageRegistryVo, topicName, consumer, routingKey, processor, "CLUSTERING");
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} consumer:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    public <T> MessageResponse subscribe(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.toSubscribe(this.messageRegistryVo, topicName, routingKey, processor, "CLUSTERING");
    }

    public <T> MessageResponse subscribe(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        String subExpression = this.getSubExpression(routingKeys);
        return this.toSubscribe(this.messageRegistryVo, topicName, subExpression, processor, "CLUSTERING");
    }

    public MessageResponse subscribe(String consumer, Map<String, Map<String, IMessageProcessor>> messageProcessorMap) {
        logger.info("consumer={}", (Object)consumer);
        this.toSubscribe(this.messageRegistryVo, consumer, messageProcessorMap, "CLUSTERING");
        return MessageResponse.SUCCESS;
    }

    public MessageResponse subscribe(String topic, String consumer, Map<String, IMessageProcessor> messageProcessorMap) {
        try {
            this.toSingleTopicSubscribe(this.messageRegistryVo, topic, consumer, messageProcessorMap, "CLUSTERING");
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} ", (Object)topic, (Object)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    private void toSubscribe(MessageRegistryVo messageRegistryVo, String consumerId, Map<String, Map<String, IMessageProcessor>> messageProcessorMap, String messageModel) {
        logger.info("consumer={}", (Object)consumerId);
        try {
            if (!consumerMap.containsKey(consumerId)) {
                this.createConsumer(messageRegistryVo, consumerId, messageModel);
            }
            Consumer consumer = consumerMap.get(consumerId);
            for (String topicName : messageProcessorMap.keySet()) {
                String subExpression = this.getSubExpression(messageProcessorMap.get(topicName).keySet().toArray());
                consumer.subscribe(topicName, subExpression, this.consumerMessageListener(messageProcessorMap.get(topicName)));
            }
            if (!consumer.isStarted()) {
                consumer.start();
            }
            logger.info("Connected to {}", (Object)messageRegistryVo.getHost());
        }
        catch (Exception e) {
            logger.info("Failed to connect to {}", (Object)messageRegistryVo.getHost(), (Object)e);
        }
    }

    private void createConsumer(MessageRegistryVo messageRegistryVo, String consumerId, String messageModel) {
        logger.info("consumer={}", (Object)consumerId);
        Properties properties = AliyunConsumerHelper.getProperties(messageRegistryVo);
        properties.setProperty("GROUP_ID", consumerId);
        properties.setProperty("ConsumerId", consumerId);
        properties.put("MessageModel", messageModel);
        properties.setProperty("ConsumeThreadNums", String.valueOf(messageRegistryVo.getConsumeThreadNums()));
        Consumer consumer = ONSFactory.createConsumer((Properties)properties);
        consumerMap.put(consumerId, consumer);
    }

    private MessageListener consumerMessageListener(final Map<String, IMessageProcessor> messageProcessorMap) {
        return new MessageListener(){

            public Action consume(Message message, ConsumeContext context) {
                if (logger.isInfoEnabled()) {
                    logger.info("Receive message success! message:{}" + message.toString());
                }
                try {
                    IMessageProcessor messageProcessor = (IMessageProcessor)messageProcessorMap.get(message.getTag());
                    if (messageProcessor == null) {
                        logger.warn("\u65e0\u6d88\u606f\u8ba2\u9605\u8005\uff0ctag={}", (Object)message.getTag());
                        return Action.CommitMessage;
                    }
                    Object messageBody = AliyunConsumer.this.unpackMessage(message, messageProcessor);
                    String msgId = message.getMsgID();
                    if (messageProcessor.isDuplicationMessage(msgId, messageBody)) {
                        logger.info("\u91cd\u590d\u6d88\u606f\uff1amsgId={}", (Object)msgId);
                        return Action.CommitMessage;
                    }
                    AliyunConsumer.this.addServiceContext(message);
                    MessageResponse result = messageProcessor.process(messageBody);
                    if (result == null) {
                        return Action.ReconsumeLater;
                    }
                    if ("error".equals(result.getResultMsg())) {
                        return Action.ReconsumeLater;
                    }
                    return Action.CommitMessage;
                }
                catch (BusinessRuntimeException e) {
                    return Action.CommitMessage;
                }
                catch (Exception e) {
                    return Action.ReconsumeLater;
                }
            }
        };
    }

    private Object unpackMessage(Message message, IMessageProcessor messageProcessor) {
        Object messageBody;
        if (this.serializeCode.isJdkSerializer()) {
            messageBody = this.serializeCode.deSerialize(message.getBody(), null);
        } else {
            String clazzJson = message.getUserProperties("mqMessageBodyClassInfo");
            if (StringUtils.isEmpty((Object)clazzJson)) {
                messageBody = this.serializeCode.deSerialize(message.getBody(), messageProcessor.getMsgType());
            } else {
                Class msgType = (Class)JacksonUtil.readValue((String)clazzJson, Class.class);
                messageBody = this.serializeCode.deSerialize(message.getBody(), (Type)msgType);
            }
        }
        return messageBody;
    }

    private void addServiceContext(Message message) {
        if (!this.messageRegistryVo.isPassSvcContext()) {
            return;
        }
        Properties properties = message.getUserProperties();
        if (properties != null && properties.size() > 0) {
            ServiceContext serviceContext = ServiceContext.getContext();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String kStr = k.toString();
                if (kStr.startsWith("_context-") && v != null) {
                    kStr = kStr.substring("_context-".length());
                    serviceContext.set(kStr, (Object)v.toString());
                }
            }));
        }
    }

    private void toSingleTopicSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String consumerId, Map<String, IMessageProcessor> messageProcessorMap, String messageModel) {
        try {
            if (!consumerMap.containsKey(consumerId)) {
                this.createConsumer(messageRegistryVo, consumerId, messageModel);
            }
            Consumer consumer = consumerMap.get(consumerId);
            String subExpression = this.getSubExpression(messageProcessorMap.keySet().toArray());
            consumer.subscribe(topicName, subExpression, this.consumerMessageListener(messageProcessorMap));
            if (!consumer.isStarted()) {
                consumer.start();
            }
            logger.info("Connected to {}", (Object)messageRegistryVo.getHost());
        }
        catch (Exception e) {
            logger.info("Failed to connect to {}", (Object)messageRegistryVo.getHost(), (Object)e);
        }
    }

    public MessageResponse unsubscribe(String topicName, String routingKey) {
        try {
            Consumer consumer = consumerMap.get(this.messageRegistryVo.getConsumerId());
            consumer.unsubscribe(topicName);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u8ba2\u9605\u5931\u8d25\uff0ctopicName\uff1a{}", (Object)topicName, (Object)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    private void toSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String consumerId, String routingKey, IMessageProcessor processor, String messageModel) {
        HashMap<String, IMessageProcessor> messageProcessorMap = new HashMap<String, IMessageProcessor>();
        messageProcessorMap.put(routingKey, processor);
        this.toSingleTopicSubscribe(messageRegistryVo, topicName, consumerId, messageProcessorMap, messageModel);
    }

    private <T> MessageResponse toSubscribe(MessageRegistryVo messageRegistryVo, String topicName, String routingKey, IMessageProcessor<T> processor, String messageModel) {
        try {
            this.toSubscribe(messageRegistryVo, topicName, messageRegistryVo.getConsumerId(), routingKey, processor, messageModel);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} consumer:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException(e.getMessage());
        }
    }

    public <T> MessageResponse subscribeBroadcastMessage(String topicName, String routingKey, IMessageProcessor<T> processor) {
        return this.toSubscribe(this.messageRegistryVo, topicName, routingKey, processor, "BROADCASTING");
    }

    public <T> MessageResponse subscribeBroadcastMessage(String topicName, String[] routingKeys, IMessageProcessor<T> processor) {
        String subExpression = this.getSubExpression(routingKeys);
        return this.toSubscribe(this.messageRegistryVo, topicName, subExpression, processor, "BROADCASTING");
    }
}

