/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.aliyun;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.api.AbstractProducer;
import com.dtyunxi.huieryun.mq.api.SendCallback;
import com.dtyunxi.huieryun.mq.constant.MQConstants;
import com.dtyunxi.huieryun.mq.provider.aliyun.util.AliyunConsumerHelper;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.retry.vo.RetryerRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunProducer
extends AbstractProducer {
    private static final Logger logger = LoggerFactory.getLogger(AliyunProducer.class);
    private static final ThreadLocal<Integer> messageType = new ThreadLocal();
    private static final AliyunProducer single = new AliyunProducer();
    private Producer producer;

    private AliyunProducer() {
    }

    public static AliyunProducer getInstance() {
        return single;
    }

    protected Boolean connectMQServer() {
        try {
            Properties properties = AliyunConsumerHelper.getProperties(this.messageRegistryVo);
            this.producer = ONSFactory.createProducer((Properties)properties);
            this.producer.start();
            return true;
        }
        catch (ONSClientException e) {
            logger.error("\u521b\u5efaAliyun Producer\u5ba2\u6237\u7aef\u5f02\u5e38\uff01host:{},username:{},password{}", new Object[]{this.messageRegistryVo.getHost(), this.messageRegistryVo.getUsername(), this.messageRegistryVo.getPassword(), e});
        }
        catch (Exception e) {
            logger.error("\u521b\u5efaAliyun Producer\u65f6\u51fa\u9519\uff0c host:{},username:{},password{}", new Object[]{this.messageRegistryVo.getHost(), this.messageRegistryVo.getUsername(), this.messageRegistryVo.getPassword(), e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
        return false;
    }

    public MessageResponse sendSingleMessage(String topicName, String queueName, Object message, long delayTime) {
        messageType.set(MQConstants.MQ_SEDN_TYPE_SINGLE);
        return this.executeMessageSend(topicName, queueName, message, delayTime);
    }

    public MessageResponse sendMessage(String topicName, String routingKey, Object message, long delayTime) {
        messageType.set(MQConstants.MQ_SEDN_TYPE_PUB);
        return this.executeMessageSend(topicName, routingKey, message, delayTime);
    }

    private MessageResponse executeMessageSend(String topicName, String routingKey, Object message, long delayTime) {
        if (this.producer == null) {
            throw new BusinessRuntimeException("\u963f\u91cc\u4e91MQ\u53d1\u9001\u8005\u5c1a\u672a\u521b\u5efa\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f\uff01");
        }
        try {
            Message msg = this.packMessage(topicName, routingKey, message);
            msg.setKey("ORDERID_" + this.getMessageId());
            if (delayTime > 0L) {
                msg.setStartDeliverTime(System.currentTimeMillis() + delayTime * 1000L);
            }
            SendResult result = this.sendMessage(msg);
            logger.info("messageKey:{}  messageId:{}", (Object)msg.getKey(), (Object)result.getMessageId());
            return new MessageResponse((Object)result.getMessageId());
        }
        catch (ONSClientException e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5ba2\u6237\u7aef\u5f02\u5e38\uff0c\u8bf7\u53c2\u8003\u963f\u91cc\u7ed9\u51fa\u6307\u5f15\u94fe\u63a5\u5904\u7406\uff01topicName\uff1a{} routingKey:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{topicName, routingKey, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    public MessageResponse sendAsyncSingleMessage(String topic, String queueName, Object message, long delayTime, SendCallback callback) {
        messageType.set(MQConstants.MQ_SEDN_TYPE_SINGLE);
        return this.executeAsyncMessageSend(topic, queueName, message, delayTime, callback);
    }

    public MessageResponse sendAsyncMessage(String routingKey, Object message, SendCallback callback) {
        messageType.set(MQConstants.MQ_SEDN_TYPE_PUB);
        return this.executeAsyncMessageSend(this.messageRegistryVo.getTopicName(), routingKey, message, 0L, callback);
    }

    public MessageResponse sendAsyncMessage(String routingKey, Object message, long delayTime, SendCallback callback) {
        messageType.set(MQConstants.MQ_SEDN_TYPE_PUB);
        return this.executeAsyncMessageSend(this.messageRegistryVo.getTopicName(), routingKey, message, delayTime, callback);
    }

    public MessageResponse sendAsyncMessage(String topic, String routingKey, Object message, long delayTime, SendCallback callback) {
        messageType.set(MQConstants.MQ_SEDN_TYPE_PUB);
        return this.executeAsyncMessageSend(topic, routingKey, message, delayTime, callback);
    }

    private MessageResponse executeAsyncMessageSend(String topic, String routingKey, Object message, long delayTime, SendCallback callback) {
        if (this.producer == null) {
            throw new BusinessRuntimeException("\u963f\u91cc\u4e91MQ\u53d1\u9001\u8005\u5c1a\u672a\u521b\u5efa\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f\uff01");
        }
        try {
            Message msg = this.packMessage(topic, routingKey, message);
            msg.setKey("ORDERID_" + this.getMessageId());
            if (delayTime > 0L) {
                msg.setStartDeliverTime(System.currentTimeMillis() + delayTime * 1000L);
            }
            logger.info("\u5f00\u59cb\u53d1\u9001\u5f02\u6b65\u6d88\u606f,topic:{}, tag:{},key:{}", new Object[]{msg.getTopic(), msg.getTag(), msg.getKey()});
            this.sendAsync(msg, callback);
            return MessageResponse.SUCCESS;
        }
        catch (ONSClientException e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5ba2\u6237\u7aef\u5f02\u5e38\uff0c\u8bf7\u53c2\u8003\u963f\u91cc\u7ed9\u51fa\u6307\u5f15\u94fe\u63a5\u5904\u7406\uff01topicName\uff1a{} routingKey:{}", new Object[]{topic, routingKey, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{topic, routingKey, e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    private Message packMessage(String topic, String routingKey, Object message) {
        Message msg = new Message(topic, routingKey, this.serializeCode.serialize(message));
        if (this.serializeCode.isJdkSerializer()) {
            return msg;
        }
        msg.putUserProperties("mqMessageBodyClassInfo", JacksonUtil.toJson(message.getClass()));
        return msg;
    }

    public MessageResponse sendBroadcastMessage(String topic, String routingKey, Object message, long delayTime) {
        messageType.set(MQConstants.MQ_SEDN_TYPE_BROADCAST);
        return this.executeMessageSend(topic, routingKey, message, delayTime);
    }

    public MessageResponse sendAsyncBroadcastMessage(String topic, String routingKey, Object message, long delayTime, SendCallback callback) {
        messageType.set(MQConstants.MQ_SEDN_TYPE_BROADCAST);
        return this.executeAsyncMessageSend(topic, routingKey, message, 0L, callback);
    }

    private SendResult sendMessage(Message msg) throws Exception {
        Callable<SendResult> sendMessageCallable = this.createSendMessageCallable(msg);
        return sendMessageCallable.call();
    }

    private Callable<SendResult> createSendMessageCallable(final Message msg) {
        this.addServiceContext(msg);
        return new Callable<SendResult>(){

            @Override
            public SendResult call() throws Exception {
                try {
                    if (!AliyunProducer.this.producer.isStarted()) {
                        AliyunProducer.this.producer.start();
                    }
                    return AliyunProducer.this.producer.send(msg);
                }
                catch (ONSClientException e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u5ba2\u6237\u7aef\u5f02\u5e38\uff0c\u8bf7\u53c2\u8003\u963f\u91cc\u7ed9\u51fa\u6307\u5f15\u94fe\u63a5\u5904\u7406\uff01topicName\uff1a{} routingKey:{}", new Object[]{msg.getTopic(), msg.getTag(), e});
                    throw e;
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{msg.getTopic(), msg.getTag(), e});
                    throw e;
                }
            }
        };
    }

    private void addServiceContext(Message msg) {
        if (!this.messageRegistryVo.isPassSvcContext()) {
            return;
        }
        ServiceContext.getContext().getKeys().forEach((k, v) -> {
            if (k != null && v != null) {
                msg.putUserProperties("_context-" + k, v.toString());
            }
        });
    }

    private Callable<Boolean> createAsyncMessageCallable(final Message msg, final SendCallback callback) {
        this.addServiceContext(msg);
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    if (!AliyunProducer.this.producer.isStarted()) {
                        AliyunProducer.this.producer.start();
                    }
                    AliyunProducer.this.producer.sendAsync(msg, AliyunProducer.this.createMessageSendCallback(msg, callback));
                    return true;
                }
                catch (ONSClientException e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u5ba2\u6237\u7aef\u5f02\u5e38\uff0c\u8bf7\u53c2\u8003\u963f\u91cc\u7ed9\u51fa\u6307\u5f15\u94fe\u63a5\u5904\u7406\uff01topicName\uff1a{} routingKey:{}", new Object[]{msg.getTopic(), msg.getTag(), e});
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff0ctopicName\uff1a{} routingKey:{}", new Object[]{msg.getTopic(), msg.getTag(), e});
                }
                return false;
            }
        };
    }

    private void sendAsync(Message msg, SendCallback callback) throws Exception {
        RetryerRegistryVo retryerRegistryVo = this.getRetryerRegistryVo();
        Callable<Boolean> asyncMessageCallable = this.createAsyncMessageCallable(msg, callback);
        if (retryerRegistryVo.isRetryEnable()) {
            this.getRetryService().retryWithResultAndIncreaseStrategy((Object)true, retryerRegistryVo.getInitialSleepTime(), retryerRegistryVo.getIncrementSleepTime(), retryerRegistryVo.getAttemptNumber(), asyncMessageCallable);
        } else {
            asyncMessageCallable.call();
        }
    }

    private com.aliyun.openservices.ons.api.SendCallback createMessageSendCallback(final Message msg, final SendCallback callback) {
        return new com.aliyun.openservices.ons.api.SendCallback(){

            public void onSuccess(SendResult sendResult) {
                logger.info("\u53d1\u9001\u5f02\u6b65\u6d88\u606f\u6210\u529f! Topic is {}, tag:{},msgId is: {}, key:{}", new Object[]{sendResult.getTopic(), msg.getTag(), sendResult.getMessageId(), msg.getKey()});
                callback.onSuccess(sendResult.getMessageId());
            }

            public void onException(OnExceptionContext context) {
                logger.info("\u53d1\u9001\u6d88\u606f\u51fa\u9519! Topic is {}, msgId is: {}", (Object)context.getTopic(), (Object)context.getMessageId());
                callback.onException((Exception)context.getException(), context.getMessageId());
            }
        };
    }

    public void shutdown() {
        if (this.producer != null) {
            this.producer.shutdown();
        }
    }
}

