/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.aliyun.assembler;

import com.aliyun.openservices.ons.api.Message;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MQMessageVo;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.util.CollectionUtils;

public class MessageAssembler {
    private MessageAssembler() {
    }

    public static MQMessageVo messageToVo(Message message, SerializeCode serializeCode) {
        MQMessageVo messageVo = new MQMessageVo(serializeCode);
        HashMap headerList = new HashMap(message.getUserProperties().size());
        if (!message.getUserProperties().isEmpty()) {
            message.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> headerList.put(key.toString(), value.toString())));
        }
        messageVo.setHeaderList(headerList);
        messageVo.setMessageKey(message.getKey());
        messageVo.setDelayTime((message.getStartDeliverTime() - System.currentTimeMillis()) / 1000L);
        messageVo.setMessageBody(message.getBody());
        messageVo.setTag(message.getTag());
        messageVo.setTopic(message.getTopic());
        messageVo.setMessageId(message.getMsgID());
        if (headerList.containsKey("mqMessageBodyClassInfo")) {
            String messageBodyClass = (String)headerList.get("mqMessageBodyClassInfo");
            headerList.remove("mqMessageBodyClassInfo");
            messageVo.setMessageBodyClass(messageBodyClass);
        }
        return messageVo;
    }

    public static Message messageVoToMessage(MQMessageVo messageVo) {
        long delayTime;
        Message message = new Message(messageVo.getTopic(), messageVo.getTag(), messageVo.getMessageBody());
        if (!CollectionUtils.isEmpty((Map)messageVo.getHeaderList())) {
            messageVo.getHeaderList().forEach((key, value) -> message.putUserProperties(key, value));
        }
        if ((delayTime = messageVo.getDelayTime()) > 0L) {
            message.setStartDeliverTime(System.currentTimeMillis() + delayTime * 1000L);
        }
        if (messageVo.getSerializeCode().isJdkSerializer()) {
            return message;
        }
        message.putUserProperties("mqMessageBodyClassInfo", messageVo.getMessageBodyClass());
        return message;
    }
}

