/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit.impl;

import com.dtyunxi.huieryun.mq.provider.rabbit.QueueNameConvertUtil;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageInfo;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.RabbitBaseService;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageManager
extends RabbitBaseService {
    private static Logger logger = LoggerFactory.getLogger(MessageManager.class);
    protected Channel channel;
    protected final SerializeCode serializeCode;

    public MessageManager(MessageRegistryVo messageRegistryVo, Channel channel) {
        this.messageRegistryVo = messageRegistryVo;
        this.channel = channel;
        this.serializeCode = this.messageRegistryVo.getSerializeCode();
    }

    protected void exchangeDeclare(String exchangeName) throws IOException {
        logger.info("channel={}, exchangeName={}", (Object)this.channel, (Object)exchangeName);
        this.channel.exchangeDeclare(exchangeName, "direct", this.durable);
    }

    protected void declareQueue(String queueName, String exchangeName, long delayTime) throws IOException {
        logger.info("queueName={}, exchangeName={}, delayTime={}", new Object[]{this.channel, exchangeName, delayTime});
        this.declareMessageQueue(queueName, exchangeName, delayTime, this.channel);
    }

    protected AMQP.Queue.BindOk declareMessageQueue(String routingKey, String exchangeName, long delayTime, Channel channel) throws IOException {
        String queueName = QueueNameConvertUtil.queueNameWithExchangeAndRoutingKey(exchangeName, routingKey, routingKey);
        this.getTempMessage(routingKey, exchangeName, queueName, delayTime, channel);
        channel.queueDeclare(queueName, this.durable, false, false, null);
        return channel.queueBind(queueName, exchangeName, routingKey);
    }

    public void declareMessageDelayQueue(String routingKey, String exchangeName, long delayTime) throws IOException {
        this.getTempMessage(routingKey, exchangeName, routingKey, delayTime, this.channel);
    }

    public String sendMessage(MessageInfo messageInfo) throws IOException {
        this.exchangeDeclare(messageInfo.getTopicName());
        this.declareMessageQueue(messageInfo.getRoutingKey(), messageInfo.getTopicName(), messageInfo.getDelayTime(), this.channel);
        String messageId = messageInfo.getMessageId();
        byte[] bytes = this.serializeCode.serialize(messageInfo.getMessage());
        if (messageInfo.getDelayTime() > 0L) {
            AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().contentEncoding("UTF-8").messageId(messageId).deliveryMode(Integer.valueOf(2)).expiration(String.valueOf(messageInfo.getDelayTime() * 1000L)).headers(messageInfo.getHeaders()).build();
            this.channel.basicPublish("delay." + messageInfo.getTopicName(), "delay." + messageInfo.getRoutingKey() + "_" + messageInfo.getDelayTime(), props, bytes);
        } else {
            AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().contentEncoding("UTF-8").messageId(messageId).deliveryMode(Integer.valueOf(2)).headers(messageInfo.getHeaders()).build();
            this.channel.basicPublish(messageInfo.getTopicName(), messageInfo.getRoutingKey(), props, bytes);
        }
        return messageId;
    }

    private void getTempMessage(String routingKey, String exchangeName, String queueName, long delayTime, Channel channel) throws IOException {
        if (delayTime > 0L) {
            String delayExchange = "delay." + exchangeName;
            String delayQueue = "delay." + queueName + "_" + delayTime;
            String delayRoutingKey = "delay." + routingKey + "_" + delayTime;
            channel.exchangeDeclare(delayExchange, "direct", false, true, null);
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("x-dead-letter-exchange", exchangeName);
            args.put("x-dead-letter-routing-key", routingKey);
            channel.queueDeclare(delayQueue, this.durable, false, true, args);
            channel.queueBind(delayQueue, delayExchange, delayRoutingKey);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String toString() {
        return "MessageManager [" + (this.channel != null ? "channel=" + this.channel + ", " : "") + (this.messageRegistryVo != null ? "messageRegistryVo=" + this.messageRegistryVo + ", " : "") + "durable=" + this.durable + ", prefetchCount=" + this.prefetchCount + ", autoAck=" + this.autoAck + "]";
    }
}

