/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit.impl;

import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageInfo;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.MessageManager;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageManagerWithTopics
extends MessageManager {
    private static Logger logger = LoggerFactory.getLogger(MessageManagerWithTopics.class);

    public MessageManagerWithTopics(MessageRegistryVo messageRegistryVo, Channel channel) {
        super(messageRegistryVo, channel);
    }

    @Override
    protected void exchangeDeclare(String exchangeName) throws IOException {
        logger.debug("channel={}, exchangeName={}", (Object)this.channel, (Object)exchangeName);
        this.channel.exchangeDeclare(exchangeName, "topic", true);
    }

    public String sendTopicMessage(MessageInfo messageInfo) {
        try {
            this.exchangeDeclare(messageInfo.getTopicName());
            this.declareMessageDelayQueue(messageInfo.getRoutingKey(), messageInfo.getTopicName(), messageInfo.getDelayTime());
            String messageId = messageInfo.getMessageId();
            AMQP.BasicProperties props = new AMQP.BasicProperties.Builder().contentEncoding("UTF-8").messageId(messageId).deliveryMode(Integer.valueOf(2)).build();
            byte[] bytes = this.serializeCode.serialize(messageInfo.getMessage());
            if (messageInfo.getDelayTime() > 0L) {
                this.channel.basicPublish("delay." + messageInfo.getTopicName(), "delay." + messageInfo.getRoutingKey(), props, bytes);
            } else {
                this.channel.basicPublish(messageInfo.getTopicName(), messageInfo.getRoutingKey(), props, bytes);
            }
            return messageId;
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519 exchangeName:{},routingKey{}", new Object[]{messageInfo.getTopicName(), messageInfo.getRoutingKey(), e});
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "MessageManagerWithTopics [" + (this.channel != null ? "channel=" + this.channel + ", " : "") + (this.messageRegistryVo != null ? "messageRegistryVo=" + this.messageRegistryVo + ", " : "") + "durable=" + this.durable + ", prefetchCount=" + this.prefetchCount + ", autoAck=" + this.autoAck + "]";
    }
}

