/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit.impl;

import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.RabbitBaseService;
import com.dtyunxi.huieryun.mq.provider.rabbit.impl.Subscription;
import com.dtyunxi.huieryun.retry.vo.RetryerRegistryVo;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMqManager
extends RabbitBaseService
implements ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMqManager.class);
    protected final ConnectionFactory factory;
    protected volatile Connection connection;
    protected Address[] HOST_ARRAY;
    protected static final ReentrantLock lock = new ReentrantLock();

    public RabbitMqManager(ConnectionFactory factory, String[] addresses) {
        this.factory = factory;
        this.connection = null;
        this.initAddress(addresses);
    }

    public void start() {
        Boolean result = this.connectMQServer();
        if (result == null || !result.booleanValue()) {
            RetryerRegistryVo retryerRegistryVo = this.getRetryerRegistryVo();
            this.getRetryService().retryWithResultAndIncreaseStrategy((Object)true, retryerRegistryVo.getInitialSleepTime(), retryerRegistryVo.getIncrementSleepTime(), retryerRegistryVo.getAttemptNumber(), this.createConnectMQServerCallable());
        }
    }

    private Boolean connectMQServer() {
        if (lock.isLocked()) {
            return true;
        }
        try {
            lock.lock();
            if (this.HOST_ARRAY == null) {
                this.connection = this.factory.newConnection();
                logger.info("Connected to {} : {}", (Object)this.factory.getHost(), (Object)this.factory.getPort());
            } else {
                this.connection = this.factory.newConnection(this.HOST_ARRAY);
                if (logger.isInfoEnabled()) {
                    logger.info("Connected to:{}", (Object)JacksonUtil.toJson((Object)this.HOST_ARRAY));
                }
            }
            this.connection.addShutdownListener((ShutdownListener)this);
            logger.info("--------\u83b7\u53d6MQ\u8fde\u63a5\u6210\u529f---------");
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (this.HOST_ARRAY == null) {
                logger.error("\u83b7\u53d6mq\u8fde\u63a5\u5931\u8d25,IP:{},PORT:{}", new Object[]{this.factory.getHost(), this.factory.getPort(), e});
            } else {
                logger.error("\u83b7\u53d6mq\u8fde\u63a5\u5931\u8d25:{}", (Object)this.HOST_ARRAY, (Object)e);
            }
            logger.info("-------\u83b7\u53d6mq\u8fde\u63a5\u5931\u8d25,\u8fdb\u884c\u91cd\u8fde\u64cd\u4f5c-------");
            this.stop();
        }
        finally {
            try {
                lock.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {}
        }
        return false;
    }

    private Callable<Boolean> createConnectMQServerCallable() {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return RabbitMqManager.this.connectMQServer();
            }
        };
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        if (!cause.isInitiatedByApplication()) {
            if (this.HOST_ARRAY == null) {
                logger.info("Lost connection to {} : {}", new Object[]{this.factory.getHost(), this.factory.getPort(), cause});
            } else {
                logger.info("Lost connection to:{}", (Object)this.HOST_ARRAY, (Object)cause);
            }
            this.stop();
            this.start();
        }
    }

    public void stop() {
        if (this.connection == null) {
            return;
        }
        if (!this.connection.isOpen()) {
            this.connection = null;
            return;
        }
        try {
            this.connection.close();
        }
        catch (Exception e) {
            logger.error("Failed to close connection", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }

    public Channel createChannel() {
        try {
            if (this.connection == null) {
                this.start();
            }
            return this.connection == null ? null : this.connection.createChannel();
        }
        catch (Exception e) {
            logger.error("Failed to create channel", (Throwable)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    public void closeChannel(Channel channel) {
        if (channel == null || !channel.isOpen()) {
            return;
        }
        try {
            channel.close();
        }
        catch (Exception e) {
            logger.error("Failed to close channel:{}", (Object)channel, (Object)e);
            throw new BusinessRuntimeException("10001", (Throwable)e);
        }
    }

    public <T> Subscription createSubscription(String exchange, String routingKey, IMessageProcessor<T> handler) {
        return new Subscription(exchange, routingKey, handler);
    }

    public <T> Subscription createSubscription(String exchange, String[] routingKeys, IMessageProcessor<T> handler) {
        return new Subscription(exchange, routingKeys, handler);
    }

    private void initAddress(String[] addresses) {
        if (addresses != null) {
            this.HOST_ARRAY = new Address[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                String[] addr = addresses[i].split(":");
                this.HOST_ARRAY[i] = new Address(addr[0], Integer.parseInt(addr[1]));
            }
        }
    }
}

