/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.huieryun.mq.provider.rabbit.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.util.SerializeCode;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SubscriptionConsumer
extends DefaultConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionConsumer.class);
    private final IMessageProcessor processor;
    private int retryCount = 0;
    private final Channel channel;
    private final MessageRegistryVo messageRegistryVo;
    protected final SerializeCode serializeCode;

    public SubscriptionConsumer(Channel channel, IMessageProcessor processor, MessageRegistryVo messageRegistryVo) {
        super(channel);
        this.processor = processor;
        this.channel = channel;
        this.messageRegistryVo = messageRegistryVo;
        this.serializeCode = this.messageRegistryVo.getSerializeCode();
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        MessageResponse result = MessageResponse.ERROR;
        Object messageBody = null;
        try {
            messageBody = this.unpackMessage(properties, body);
        }
        catch (BusinessRuntimeException e) {
            logger.error("deSerialize to {} failure! msg={}", (Object)this.processor.getMsgType());
            this.channel.basicAck(envelope.getDeliveryTag(), false);
            return;
        }
        String msgId = properties.getMessageId();
        if (this.processor.isDuplicationMessage(msgId, messageBody)) {
            logger.info("\u91cd\u590d\u6d88\u606f\uff1amsgId={}", (Object)msgId);
            this.channel.basicAck(envelope.getDeliveryTag(), false);
            return;
        }
        try {
            this.addServiceContext(properties);
            result = this.processor.process(messageBody);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (null == result || "error".equals(result.getResultMsg())) {
            logger.info("\u6d88\u606f {} \u5904\u7406\u5931\u8d25", (Object)envelope.getDeliveryTag());
            this.dealMessageAck(envelope);
        } else {
            logger.info("\u6d88\u606f {} \u5904\u7406\u6210\u529f", (Object)envelope.getDeliveryTag());
            this.channel.basicAck(envelope.getDeliveryTag(), false);
            this.retryCount = 0;
        }
    }

    private Object unpackMessage(AMQP.BasicProperties properties, byte[] body) {
        Object messageBody;
        if (this.serializeCode.isJdkSerializer()) {
            messageBody = this.serializeCode.deSerialize(body, null);
        } else {
            String clazzJson = null;
            Map headers = properties.getHeaders();
            if (headers != null && headers.containsKey("mqMessageBodyClassInfo")) {
                clazzJson = headers.get("mqMessageBodyClassInfo").toString();
            }
            if (StringUtils.isEmpty(clazzJson)) {
                messageBody = this.serializeCode.deSerialize(body, this.processor.getMsgType());
            } else {
                Class msgType = (Class)JacksonUtil.readValue(clazzJson, Class.class);
                messageBody = this.serializeCode.deSerialize(body, (Type)msgType);
            }
        }
        return messageBody;
    }

    private void addServiceContext(AMQP.BasicProperties properties) {
        if (!this.messageRegistryVo.isPassSvcContext()) {
            return;
        }
        ServiceContext serviceContext = ServiceContext.getContext();
        Map headers = properties.getHeaders();
        if (headers != null) {
            headers.forEach((k, v) -> {
                if (k.startsWith("_context-") && v != null) {
                    k = k.substring("_context-".length());
                    serviceContext.set(k, (Object)v.toString());
                }
            });
        }
    }

    private void dealMessageAck(Envelope envelope) throws IOException {
        ++this.retryCount;
        if (this.retryCount < 10) {
            logger.info("\u6d88\u8d39\u6d88\u606f {} \u5931\u8d25.\u7b2c{}\u6b21 \u91cd\u65b0\u653e\u5165\u961f\u5217", (Object)envelope.getDeliveryTag(), (Object)this.retryCount);
            this.channel.basicNack(envelope.getDeliveryTag(), false, true);
        } else {
            logger.info("\u6d88\u8d39\u6d88\u606f {} \u5904\u7406\u5931\u8d25\u5df2\u7ecf\u8d85\u8fc710\u6b21. \u62d2\u7edd\u8be5\u6d88\u606f", (Object)envelope.getDeliveryTag(), (Object)this.retryCount);
            this.channel.basicReject(envelope.getDeliveryTag(), false);
        }
    }
}

